import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


	import org.apache.xerces.parsers.DOMParser;

	/**
	 * XMLDOM przyjmuje ciek dostpu do pliku XML, ktry parsuje
	 * za pomoc parsera DOM i wywietla sparsowan zawarto.   
	 *
	 * @author Wiesaw Dudek
	 * @version 1.0
	 */
	public class XMLDOM {

	    /**
	     * Wykonywane jest parsowanie pliku i wywietlanie zawartoci.
	     * 
	     * @param xml String cieka dostpu do pliku XML.
	     */
	    public void parseIt(String xml) {
	        System.out.println("Parsowanie pliku XML: " + xml + "\n\n");

	        // adujemy parser
	        DOMParser parser = new DOMParser();
	        try {
	        	//parsujemy dokument
	            parser.parse(xml);
	            
	            //pobieramy struktur sparsowanego dokumentu
	            Document doc = parser.getDocument();

	            // wywietamy dokument na podstawie struktury DOM
	            showNode(doc, "");
	            

	        } catch (Exception ex) {
	            ex.printStackTrace();
	            System.out.println("Bd w parsowaniu: " + ex.getMessage());
	        }
	    }
	    
	    /**
	     * Wywietlamy wze oraz jego podwzy
	     *
	     * @param node Node wze do wywietlenia.
	     * @param indent String wcicie do wywietlenia przed wyw. wza
	     */
	    public void showNode(Node node, String indent)  {
	    	
	        //akcja zaley od typu wza
	        switch (node.getNodeType()) {
	            case Node.DOCUMENT_NODE:
	            	System.out.println("<xml version=\"1.0\" encoding=\"windows-1250\">\n");
	            	// wyswietlanie wzw potomnych
	            	NodeList nodes = node.getChildNodes();
	            	if (nodes != null) {
	            		for (int i=0; i<nodes.getLength(); i++) {
	            			showNode(nodes.item(i), "");
	            		}
	            	}	            
	            	break;

	            case Node.ELEMENT_NODE:
	            	//nazwa wza
	                String name = node.getNodeName();      
	   		     	System.out.print(indent + "<" + name);
	   		     	//wywietlenie atrybutw wza
	                NamedNodeMap attrs = node.getAttributes();
	                for (int i=0; i<attrs.getLength(); i++) {
	                    Node attr = attrs.item(i);
	                    System.out.print(" " + attr.getNodeName() +
	                                     "=\"" + attr.getNodeValue() +
	                                     "\"");
	                }
	                System.out.println(">");

			        //wywietlanie wzw potomnych
	                NodeList children = node.getChildNodes();
	                if (children != null) {
	                    for (int i=0; i<children.getLength(); i++) {
	                        showNode(children.item(i), indent + "  ");
	                    }
	                }

	                System.out.println(indent + "</" + name + ">");
	                break;

	            case Node.TEXT_NODE:
	            case Node.CDATA_SECTION_NODE:
	            	//wywietlenie danych wewntrznych wza
	            	System.out.print(node.getNodeValue());
	                break;

	            case Node.PROCESSING_INSTRUCTION_NODE:
	            	//wywietlenie instrukcji
	                System.out.println("<?" + node.getNodeName() +
                            " " + node.getNodeValue() +"?>");
	                break;

	            case Node.ENTITY_REFERENCE_NODE:
	            	// wywietlenie encji np. &gt; == >
	                System.out.print("&" + node.getNodeName() + ";");	            	
	                break;

	            case Node.DOCUMENT_TYPE_NODE:
	            	// wywietlenie DTD
	                DocumentType typeOfDoc = (DocumentType)node;
	                System.out.print("<!DOCTYPE " + typeOfDoc.getName());
	                if (typeOfDoc.getPublicId() != null)  {
	                    System.out.print(" PUBLIC \"" + typeOfDoc.getPublicId() + "\" ");
	                } else {
	                    System.out.print(" SYSTEM ");
	                }
	                System.out.println("\"" + typeOfDoc.getSystemId() + "\">");

	            	break;
	        }

	    }

	    /**
	     * wejcie programu
	     */
	    public static void main(String[] args) {
	        if (args.length != 1) {
	            System.out.println("Uycie: java XMLDOM <cieka do pliku XML>");
	            System.exit(0);
	        }

	        String xml = args[0];

	        XMLDOM parserDemo = new XMLDOM();
	        parserDemo.parseIt(xml);
	    }

	}
