//Autor: Wiesaw Dudek
//

unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ExtCtrls, ToolWin, FileCtrl,ActiveX,AxCtrls,ComObj;

type
  TStgForm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    CheckBox1: TCheckBox;
    DateTimePicker1: TDateTimePicker;
    Label2: TLabel;
    ComboBox1: TComboBox;
    GroupBox2: TGroupBox;
    Label3: TLabel;
    Edit1: TEdit;
    CheckBox2: TCheckBox;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    ToolButton4: TToolButton;
    Panel3: TPanel;
    ComboBox2: TComboBox;
    Label4: TLabel;
    procedure FormShow(Sender: TObject);
    procedure ToolButton2Click(Sender: TObject);
    procedure ToolButton4Click(Sender: TObject);
    procedure ToolButton1Click(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
  private
    { Private declarations }
    plikUS : string;
    procedure Open(plik : string);
    procedure Close;
  public
    { Public declarations }
  end;

var
  StgForm: TStgForm;

implementation

{$R *.DFM}

var mainStorage : IStorage;
    visitStorage : IStorage;
    versionStream : IStream;
    mainVisitDataStream : IStream;
    diagnosisDataStream : IStream;
    oleStream : TOleStream;

    enumStorages : IEnumStatStg;
    statStorage: TStatStg;

    version : integer;
    data : TDateTime;
    bool : boolean;
    integ : longint;
    str : string;

    countRead, countWritten : longint;

procedure TStgForm.Open(plik : string);
begin
    plikUS:=plik;

    //otworzenie pliku ustrukturalizowanego skadowania
    OleCheck(StgOpenStorage(PWideChar(WideString(plik)),nil,
      STGM_READWRITE or STGM_SHARE_EXCLUSIVE,nil,0,mainStorage));

    //sprawdzenie wersji pliku
    //otworzenie strumienia z wersj w skadzie gwnym
    OleCheck(mainStorage.OpenStream('version',nil,
      STGM_READ or STGM_SHARE_EXCLUSIVE,0,versionStream));

    //odczyt numeru wersji pliku bez posrednictwa TOleStream
    OleCheck(versionStream.Read(@version,SizeOf(version),@countRead));
    if version<>1 then
    begin
      ShowMessage('Wersja pliku niewasciwa:'+IntToStr(version));
      exit;
    end;

    //iteracja po skadach i odczyt
    ComboBox2.Clear;
    OleCheck(mainStorage.EnumElements(0,nil,0,enumStorages));
    while enumStorages.Next(1,statStorage,nil)=S_OK do
    begin
      str:=statStorage.pwcsName;
      if statStorage.dwType=STGTY_STORAGE then ComboBox2.Items.Add(str);
    end;
    ComboBox2.ItemIndex:=0;

    //zamykanie pliku
    Close;

    ComboBox2.OnChange(nil);
end;

procedure TStgForm.Close;
begin
    mainStorage:=nil;
    visitStorage:=nil;
    versionStream:=nil;
    mainVisitDataStream:=nil;
    diagnosisDataStream:=nil;
    enumStorages:=nil;
end;

procedure TStgForm.FormShow(Sender: TObject);
begin
  plikUS:='';
  Edit1.Text:='J-23';
  DateTimePicker1.DateTime:=now;
  ComboBox1.ItemIndex:=0;
end;

procedure TStgForm.ToolButton2Click(Sender: TObject);
begin
  if SaveDialog1.Execute then
  begin
    if FileExists(SaveDialog1.FileName) then
      if MessageBox(0,'Nadpisac?','Plik istnieje',mb_YesNo)=id_No then exit;

    //utworzenie pliku ustrukturalizowanego skadowania
    OleCheck(StgCreateDocFile(PWideChar(WideString(SaveDialog1.FileName)),
      STGM_CREATE or STGM_READWRITE or STGM_SHARE_EXCLUSIVE,0,mainStorage));

    //utworzenie strumienia z wersj w skadzie gwnym
    OleCheck(mainStorage.CreateStream('version',STGM_CREATE
      or STGM_READWRITE or STGM_SHARE_EXCLUSIVE,0,0,versionStream));

    //zapis numeru wersji pliku bez posrednictwa TOleStream
    version:=1;
    OleCheck(versionStream.Write(@version,SizeOf(version),@countWritten));

    //-------------------------------------------------

    //utworzenie podskadu "wizyta" w skadzie gwnym
    OleCheck(mainStorage.CreateStorage(PWideChar(WideString('Wizyta'+
      DateToStr(DateTimePicker1.Date))),
      STGM_CREATE or STGM_READWRITE or STGM_SHARE_EXCLUSIVE,0,0,visitStorage));

    //utworzenie strumienia w podsadzie
    OleCheck(visitStorage.CreateStream('mainVisitData',STGM_CREATE
      or STGM_READWRITE or STGM_SHARE_EXCLUSIVE,0,0,mainVisitDataStream));

    //zapis danych do pliku z wykorzystaniem TOleStream
    oleStream:=TOleStream.Create(mainVisitDataStream);
    try
      data:=DateTimePicker1.Date;
      oleStream.Write(data,SizeOf(DateTimePicker1.Date));
      bool:=CheckBox1.Checked;
      oleStream.Write(bool,SizeOf(bool));
      str:=ComboBox1.Text;
      oleStream.Write(str,SizeOf(str));
    finally
      oleStream.Free;
      oleStream:=nil;
    end;

    //utworzenie strumienia w podsadzie
    OleCheck(visitStorage.CreateStream('diagnosisData',STGM_CREATE
      or STGM_READWRITE or STGM_SHARE_EXCLUSIVE,0,0,diagnosisDataStream));

    //zapis danych do pliku z wykorzystaniem TOleStream
    oleStream:=TOleStream.Create(mainVisitDataStream);
    try
      bool:=CheckBox2.Checked;
      oleStream.Write(bool,SizeOf(bool));
      str:=Edit1.Text;
      oleStream.Write(str,SizeOf(str));
    finally
      oleStream.Free;
      oleStream:=nil;
    end;

    //zamykanie pliku
    Close;

    Open(SaveDialog1.FileName);
  end;

end;

procedure TStgForm.ToolButton4Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
  begin
    //sprawdzenie czy plik jest plikiem ustrukturalizowanego skadowania
    if StgIsStorageFile(PWideChar(WideString(OpenDialog1.FileName)))<>S_OK then
    begin
      ShowMessage('Plik '+OpenDialog1.FileName+' nie jest plikiem ustrukturalizowanego skadowania.');
      exit;
    end;

    //otworzenie pliku ustrukturalizowanego skadowania
    OleCheck(StgOpenStorage(PWideChar(WideString(OpenDialog1.FileName)),nil,
      STGM_READWRITE or STGM_SHARE_EXCLUSIVE,nil,0,mainStorage));

    //sprawdzenie wersji pliku
    //otworzenie strumienia z wersj w skadzie gwnym
    OleCheck(mainStorage.OpenStream('version',nil,
      STGM_READ or STGM_SHARE_EXCLUSIVE,0,versionStream));

    //odczyt numeru wersji pliku bez posrednictwa TOleStream
    OleCheck(versionStream.Read(@version,SizeOf(version),@countRead));
    if version<>1 then
    begin
      ShowMessage('Wersja pliku niewasciwa:'+IntToStr(version));
      exit;
    end;

    //-------------------------------------------------
    //utworzenie podskadu "wizyta" w skadzie gwnym
    OleCheck(mainStorage.CreateStorage(PWideChar(WideString('Wizyta'+
      DateToStr(DateTimePicker1.Date))),
      STGM_CREATE or STGM_READWRITE or STGM_SHARE_EXCLUSIVE,0,0,visitStorage));

    //utworzenie strumienia w podsadzie
    OleCheck(visitStorage.CreateStream('mainVisitData',STGM_CREATE
      or STGM_READWRITE or STGM_SHARE_EXCLUSIVE,0,0,mainVisitDataStream));

    //zapis danych do pliku z wykorzystaniem TOleStream
    oleStream:=TOleStream.Create(mainVisitDataStream);
    try
      data:=DateTimePicker1.Date;
      oleStream.Write(data,SizeOf(DateTimePicker1.Date));
      bool:=CheckBox1.Checked;
      oleStream.Write(bool,SizeOf(bool));
      str:=ComboBox1.Text;
      integ:=Length(str);
      oleStream.Write(integ,SizeOf(integ));
      oleStream.Write(str[1],integ);
    finally
      oleStream.Free;
      oleStream:=nil;
    end;

    //utworzenie strumienia w podsadzie
    OleCheck(visitStorage.CreateStream('diagnosisData',STGM_CREATE
      or STGM_READWRITE or STGM_SHARE_EXCLUSIVE,0,0,diagnosisDataStream));

    //zapis danych do pliku z wykorzystaniem TOleStream
    oleStream:=TOleStream.Create(mainVisitDataStream);
    try
      bool:=CheckBox2.Checked;
      oleStream.Write(bool,SizeOf(bool));
      str:=Edit1.Text;
      integ:=Length(str);
      oleStream.Write(integ,SizeOf(integ));
      oleStream.Write(str[1],integ);
    finally
      oleStream.Free;
      oleStream:=nil;
    end;

    //zamykanie pliku
    Close;

    Open(OpenDialog1.FileName);
  end;
end;

procedure TStgForm.ToolButton1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
  begin
    //sprawdzenie czy plik jest plikiem ustrukturalizowanego skadowania
    if StgIsStorageFile(PWideChar(WideString(OpenDialog1.FileName)))<>S_OK then
    begin
      ShowMessage('Plik '+OpenDialog1.FileName+' nie jest plikiem ustrukturalizowanego skadowania.');
      exit;
    end;

    Open(OpenDialog1.FileName);
  end;
end;

procedure TStgForm.ComboBox2Change(Sender: TObject);
begin
    if ComboBox2.ItemIndex=-1 then exit ;

    //sprawdzenie czy plik jest plikiem ustrukturalizowanego skadowania
    if StgIsStorageFile(PWideChar(WideString(PlikUS)))<>S_OK then
    begin
      ShowMessage('Plik '+PlikUS+' nie jest plikiem ustrukturalizowanego skadowania.');
      exit;
    end;

    //otworzenie pliku ustrukturalizowanego skadowania
    OleCheck(StgOpenStorage(PWideChar(WideString(PlikUS)),nil,
      STGM_READWRITE or STGM_SHARE_EXCLUSIVE,nil,0,mainStorage));

    //sprawdzenie wersji pliku
    //otworzenie strumienia z wersj w skadzie gwnym
    OleCheck(mainStorage.OpenStream('version',nil,
      STGM_READ or STGM_SHARE_EXCLUSIVE,0,versionStream));

    //odczyt numeru wersji pliku bez posrednictwa TOleStream
    OleCheck(versionStream.Read(@version,SizeOf(version),@countRead));
    if version<>1 then
    begin
      ShowMessage('Wersja pliku niewasciwa:'+IntToStr(version));
      exit;
    end;

    //---------------------------------------------
    //odczyt z pliku i wypelnienie formularza dla wybranego skadu
    //otworzenie pdskadu
    OleCheck(mainStorage.OpenStorage(PWideChar(WideString(
      ComboBox2.Items[ComboBox2.ItemIndex])),nil,
      STGM_READWRITE or STGM_SHARE_EXCLUSIVE,nil,0,visitStorage));

    //otworzenie strumienia z wizyt w wybranym skadzie w skadzie gwnym
    OleCheck(visitStorage.OpenStream('mainVisitData',nil,
      STGM_READWRITE or STGM_SHARE_EXCLUSIVE,0,mainVisitDataStream));

    //odczyt danych z pliku z wykorzystaniem TOleStream
    oleStream:=TOleStream.Create(mainVisitDataStream);
    try
      oleStream.Read(data,SizeOf(DateTimePicker1.Date));
      DateTimePicker1.Date:=data;
      oleStream.Read(bool,SizeOf(bool));
      CheckBox1.Checked:=bool;
      oleStream.Read(integ,SizeOf(integ));
      SetLength(str,integ);
      oleStream.Read(str[1],integ);
      SetLength(str,integ);
      ComboBox1.Text:=str;
    finally
      oleStream.Free;
      oleStream:=nil;
    end;

    //otworzenie strumienia w podsadzie
    OleCheck(visitStorage.OpenStream('diagnosisData',nil,
      STGM_READ or STGM_SHARE_EXCLUSIVE,0,diagnosisDataStream));
    //zapis danych do pliku z wykorzystaniem TOleStream
    oleStream:=TOleStream.Create(mainVisitDataStream);
    try
      oleStream.Read(bool,SizeOf(bool));
      CheckBox2.Checked:=bool;
      oleStream.Read(integ,SizeOf(integ));
      SetLength(str,integ);
      oleStream.Read(str[1],integ);
      SetLength(str,integ);
      Edit1.Text:=str;
    finally
      oleStream.Free;
      oleStream:=nil;
    end;

    //zamykanie pliku
    Close;
end;

end.
