//Autor: Wiesaw Dudek
//

unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms,
  registry, Buttons, SwCalndr, Spin, StdCtrls, Dialogs;

type
  TRegistryForm = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    CheckBox1: TCheckBox;
    Edit1: TEdit;
    SpinEdit1: TSpinEdit;
    Edit2: TEdit;
    EditCalendar1: TEditCalendar;
    Edit3: TEdit;
    OpenDialog1: TOpenDialog;
    BitBtn1: TBitBtn;
    StaticText1: TStaticText;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn5: TBitBtn;
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
    procedure ReadFromRegistry ;
  public
    { Public declarations }
  end;

var
  RegistryForm: TRegistryForm;

implementation

{$R *.DFM}

procedure TRegistryForm.ReadFromRegistry ;
var Bufor : PChar ;
begin
  with TRegistry.Create do
  try
    RootKey:=HKEY_CURRENT_USER ;
    if OpenKey('Software\TIPSDelphi\RegistrySample\1.0',false) then
    begin
      if ValueExists('Tekst') then Edit1.text:=ReadString('Tekst')
      else Edit1.text:='';
      if ValueExists('Integer') then SpinEdit1.Value:=ReadInteger('Integer')
      else SpinEdit1.Value:=0;
      if ValueExists('Float') then Edit2.text:=FloatToStr(ReadFloat('Float'))
      else Edit2.text:='' ;
      if ValueExists('Boolean') then CheckBox1.Checked:=ReadBool('Boolean')
      else CheckBox1.Checked:=false;
      if ValueExists('Time') then Edit3.text:=TimeToStr(ReadTime('Time'))
      else Edit3.text:='' ;
      if ValueExists('Date') then EditCalendar1.Date:=ReadDate('Date')
      else EditCalendar1.Date:=Now;

      if ValueExists('Binary') then
      with TMemoryStream.Create do
      try
        Bufor:=StrAlloc(GetDataSize('Binary')+1);
        try
          ReadBinaryData('Binary',Bufor^,GetDataSize('Binary')) ;
          Write(Bufor^,GetDataSize('Binary')) ;
        finally
           StrDispose(Bufor) ;
        end ;
        if ValueExists('Plik') then StaticText1.Caption:=ReadString('Plik')
        else StaticText1.Caption:='Binary.exp';
        Position:=0 ; {Ustaw pozycje strumienia na pocztek}
        SaveToFile(StaticText1.Caption) ;
      finally
        Free ;
      end ;
    end ;
  finally
    CloseKey ;
    Free ;
  end ;
end ;

procedure TRegistryForm.BitBtn3Click(Sender: TObject);
begin
  Close ;
end;

procedure TRegistryForm.BitBtn5Click(Sender: TObject);
begin
  with TRegistry.Create do
  try
    RootKey:=HKEY_CURRENT_USER ;
    DeleteKey('Software\TIPSDelphi\RegistrySample\1.0') ;
  finally
    CloseKey ;
    Free ;
  end ;
  Edit1.Text:='' ;
  Edit2.Text:='' ;
  Edit3.Text:='' ;
  SpinEdit1.Value:=0 ;
  EditCalendar1.Date:=date ;
  CheckBox1.Checked:=false ;
end;

procedure TRegistryForm.BitBtn2Click(Sender: TObject);
var Liczba : double;
    Czas : TTime ;
begin
  with TRegistry.Create do
  try
    RootKey:=HKEY_CURRENT_USER ;
    OpenKey('Software\TIPSDelphi\RegistrySample\1.0',true) ;
    WriteString('Tekst',Edit1.text) ;
    WriteInteger('Integer',SpinEdit1.Value) ;

    try
      Liczba:=StrToFloat(Edit2.Text) ;
    except
      Liczba:=0 ;
    end ;

    try
      Czas:=StrToTime(Edit3.Text) ;
    except
      Czas:=0 ;
    end ;

    WriteFloat('Float',Liczba) ;
    WriteCurrency('Currency',Liczba) ;
    WriteBool('Boolean',CheckBox1.Checked) ;
    WriteTime('Time',Czas) ;
    WriteDate('Date',EditCalendar1.Date) ;
    WriteString('Plik',ExtractFileName(StaticText1.Caption)) ;
    WriteDateTime('TimeDate',EditCalendar1.Date+Czas) ;

    with TMemoryStream.Create do
    try
      try
        LoadFromFile(StaticText1.Caption) ;
      except
      end;
      Position:=0 ; {Ustaw pozycje strumienia na pocztek}
      WriteBinaryData('Binary',Memory^,Size) ;
    finally
      Free ;
    end ;
  finally
    CloseKey ;
    Free ;
  end ;
end;

procedure TRegistryForm.FormShow(Sender: TObject);
begin
  ReadFromRegistry ;  
end;

procedure TRegistryForm.BitBtn1Click(Sender: TObject);
begin
  if (StaticText1.Caption<>'<Brak>')
     and (StaticText1.Caption<>'') then OpenDialog1.FileName:=StaticText1.Caption ;
  if OpenDialog1.Execute then StaticText1.Caption:=OpenDialog1.FileName ;
end;

end.
