//Autor: Wiesaw Dudek
//

unit OsobyRekord;

interface

uses Classes, Dialogs, Sysutils;

type
  // Rekord informacji o osobie
  TOsobaRec=packed record
    Imie : String[50] ;
    Nazwisko : String[50] ;
    Plec : string[1] ;
    StazPracy : integer ; {sta pracy w latach}
  end ;

  TOsobyStream = class(TFileStream)
  private
    function DajIloscRekordow : Longint;
    function DajBiezacyRekord : Longint;
    procedure UstawBiezacyrekord(RecNo : Longint) ;
  protected
    function DajRozmiarRekordu : Longint ; virtual ;
  public
    function ZapiszRekord(const Rekord) : Longint ;
    function DodajRekord(const Rekord) : Longint ;
    function OdczytajRekord(var Rekord) : Longint ;
    procedure Pierwszy;
    procedure Ostatni ;
    procedure Nastepny ;
    procedure Poprzedni ;
    property LiczbaRekordow : Longint read DajIloscRekordow ;
    property BiezacyRekord : Longint read DajBiezacyRekord write UstawBiezacyrekord ;
  end ;

implementation

function TOsobyStream.DajIloscRekordow : Longint;
begin
  Result:=Size div DajRozmiarRekordu ;
end ;

function TOsobyStream.DajBiezacyRekord : Longint;
begin
  Result:=(Position div DajRozmiarRekordu)+1 ;
end ;

procedure TOsobyStream.UstawBiezacyrekord(RecNo : Longint) ;
begin
  if RecNo>0 then
    Position:=(RecNo-1)*DajRozmiarRekordu
  else Raise Exception.Create('Numer rekordu nie moe by mniejszy od zera!') ;
end ;

function TOsobyStream.DajRozmiarRekordu : Longint ;
begin
  Result:=SizeOf(TOsobaRec) ;
end ;

function TOsobyStream.ZapiszRekord(const Rekord) : Longint;
begin
  Result:=Write(Rekord,DajRozmiarRekordu) ;
  Seek(-DajRozmiarRekordu, 1) ;
end ;

function TOsobyStream.DodajRekord(const Rekord) : Longint ;
begin
  Seek(0,2) ;
  Result:=Write(Rekord,DajRozmiarRekordu) ;
end ;

function TOsobyStream.OdczytajRekord(var Rekord) : Longint ;
begin
  Result:=Read(Rekord,DajRozmiarRekordu) ;
  Seek(-DajRozmiarRekordu, 1) ;
end ;

procedure TOsobyStream.Pierwszy;
begin
  Seek(0,0) ;
end ;

procedure TOsobyStream.Ostatni ;
begin
  Seek(0,2) ;
  Seek(-DajRozmiarRekordu,1) ;
end ;

procedure TOsobyStream.Nastepny ;
begin
  if ((Position + DajRozmiarRekordu) div DajRozmiarRekordu)=DajIloscRekordow then
    raise Exception.Create('Odczyt poza kocem pliku!')
  else Seek(DajRozmiarRekordu, 1) ;
end ;

procedure TOsobyStream.Poprzedni ;
begin
  if (Position - DajRozmiarRekordu>=0) then
    Seek(-DajRozmiarRekordu, 1)
  else
    raise Exception.Create('Odczyt przed pocztkiem pliku!') ;
end ;

end.
