//Autor: Wiesaw Dudek
//

unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, OsobyRekord,
  StdCtrls, Buttons;

const
  FFileName ='OSOBY.DAT' ;
type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    BitBtn5: TBitBtn;
    BitBtn6: TBitBtn;
    BitBtn7: TBitBtn;
    BitBtn8: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BitBtn8Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure BitBtn7Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    OsobaRec : TOsobaRec ;
    OsobyStream: TOsobyStream ;
    procedure PokazBiezacyRekord ;
  end;

var
  Form1: TForm1;

implementation


{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  if FileExists(FFileName) then
    OsobyStream:=TOsobyStream.Create(FFileName,fmOpenReadWrite)
  else OsobyStream:=TOsobyStream.Create(FFileName,fmCreate) ;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  OsobyStream.Free ;
end;

procedure TForm1.PokazBiezacyRekord ;
begin
  OsobyStream.OdczytajRekord(OsobaRec) ;
  with OsobaRec do
  begin
    Edit1.Text:=Imie ;
    Edit2.Text:=Nazwisko ;
    Edit3.Text:=Plec ;
    Edit4.Text:=IntToStr(StazPracy) ;
  end ;
  Label1.Caption:=IntToStr(OsobyStream.BiezacyRekord) ;
  Label2.Caption:=IntToStr(OsobyStream.LiczbaRekordow) ;
end ;

procedure TForm1.BitBtn8Click(Sender: TObject);
begin
  Close ;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  if OsobyStream.LiczbaRekordow<>0 then PokazBiezacyRekord ;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  if OsobyStream.LiczbaRekordow<>0 then
  begin
    OsobyStream.Pierwszy ;
    PokazBiezacyRekord ;
  end ;
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
  if OsobyStream.LiczbaRekordow<>0 then
  begin
    OsobyStream.Poprzedni ;
    PokazBiezacyRekord ;
  end ;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
  if OsobyStream.LiczbaRekordow<>0 then
  begin
    OsobyStream.Nastepny ;
    PokazBiezacyRekord ;
  end ;
end;

procedure TForm1.BitBtn4Click(Sender: TObject);
begin
  if OsobyStream.LiczbaRekordow<>0 then
  begin
    OsobyStream.Ostatni ;
    PokazBiezacyRekord ;
  end ;
end;

procedure TForm1.BitBtn6Click(Sender: TObject);
begin
  with OsobaRec do
  begin
    Imie:=Edit1.text ;
    Nazwisko:=Edit2.text ;
    Plec:=Edit3.text ;
    StazPracy:=StrToIntDef(Edit4.text,0) ;
  end ;
  OsobyStream.ZapiszRekord(OsobaRec) ;
end;

procedure TForm1.BitBtn5Click(Sender: TObject);
begin
  with OsobaRec do
  begin
    Imie:=Edit1.text ;
    Nazwisko:=Edit2.text ;
    Plec:=Edit3.text ;
    StazPracy:=StrToIntDef(Edit4.text,0) ;
  end ;
  OsobyStream.DodajRekord(OsobaRec) ;
  PokazBiezacyRekord ;
end;

procedure TForm1.BitBtn7Click(Sender: TObject);
begin
  Edit1.Text:='' ;
  Edit2.Text:='' ;
  Edit3.Text:='' ;
  Edit4.Text:='0' ;
end;

end.
