//Autor: Wiesaw Dudek
//


unit INIFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, IniFiles;

type
  TINIForm = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Edit3: TEdit;
    Label4: TLabel;
    Memo1: TMemo;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    ComboBox1: TComboBox;
    BitBtn5: TBitBtn;
    ComboBox2: TComboBox;
    BitBtn6: TBitBtn;
    procedure BitBtn4Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
    procedure RefreshAll ;
  public
    { Public declarations }
  end;

var
  INIForm: TINIForm;

implementation

{$R *.DFM}

procedure TINIForm.BitBtn4Click(Sender: TObject);
begin
  Close ;
end;

procedure TINIForm.RefreshAll ;
begin
  with TIniFile.Create(ExtractFilePath(Application.ExeName)+'Sample.ini') do
  try
    ReadSections(ComboBox1.Items);
  finally
    Free ;
  end ;
  ComboBox1.ItemIndex:=0 ;
  ComboBox1.OnChange(nil) ;
  Memo1.Clear ;
  if FileExists(ExtractFilePath(Application.ExeName)+'Sample.ini') then Memo1.Lines.LoadFromFile(ExtractFilePath(Application.ExeName)+'Sample.ini') ;
end ;

procedure TINIForm.FormShow(Sender: TObject);
begin
  RefreshAll ;
end;

procedure TINIForm.BitBtn5Click(Sender: TObject);
var aSection : string ;
begin
  if InputQuery('Dodawanie sekcji','Podaj nazw sekcji: ',aSection) then
  begin
    with TIniFile.Create(ExtractFilePath(Application.ExeName)+'Sample.ini') do
    try
      WriteString(aSection,'New','');
      UpdateFile ;
    finally
      Free ;
    end ;
    ComboBox1.ItemIndex:=ComboBox1.Items.Add(aSection) ;
    ComboBox1.OnChange(nil) ;
    ComboBox2.ItemIndex:=0 ;
    Memo1.Clear ;
    Memo1.Lines.LoadFromFile(ExtractFilePath(Application.ExeName)+'Sample.ini') ;
  end ;
end;

procedure TINIForm.ComboBox1Change(Sender: TObject);
begin
  with TIniFile.Create(ExtractFilePath(Application.ExeName)+'Sample.ini') do
  try
    ReadSection(ComboBox1.Text,ComboBox2.Items);
  finally
    Free ;
  end ;
  ComboBox2.ItemIndex:=0 ;
  ComboBox2.OnChange(nil) ;
end;

procedure TINIForm.ComboBox2Change(Sender: TObject);
begin
  with TIniFile.Create(ExtractFilePath(Application.ExeName)+'Sample.ini') do
  try
    Edit3.text:=ReadString(ComboBox1.Text,ComboBox2.Text,'');
  finally
    Free ;
  end ;
end;

procedure TINIForm.BitBtn6Click(Sender: TObject);
var aIdent : string ;
begin
  if InputQuery('Dodawanie identyfikatora','Podaj nazw identyfikatora: ',aIdent) then
  begin
    with TIniFile.Create(ExtractFilePath(Application.ExeName)+'Sample.ini') do
    try
      WriteString(ComboBox1.Text,aIdent,'');
      UpdateFile ;
    finally
      Free ;
    end ;
    ComboBox2.ItemIndex:=ComboBox2.Items.Add(aIdent) ;
    ComboBox2.OnChange(nil) ;
    Edit3.text:='' ;
    Memo1.Clear ;
    Memo1.Lines.LoadFromFile(ExtractFilePath(Application.ExeName)+'Sample.ini') ;
  end ;
end;

procedure TINIForm.BitBtn1Click(Sender: TObject);
begin
  with TIniFile.Create(ExtractFilePath(Application.ExeName)+'Sample.ini') do
  try
    WriteString(ComboBox1.Text,ComboBox2.Text,Edit3.text);
    UpdateFile ;
  finally
    Free ;
  end ;
  Memo1.Clear ;
  Memo1.Lines.LoadFromFile(ExtractFilePath(Application.ExeName)+'Sample.ini') ;
end;

procedure TINIForm.BitBtn3Click(Sender: TObject);
begin
  with TIniFile.Create(ExtractFilePath(Application.ExeName)+'Sample.ini') do
  try
    EraseSection(ComboBox1.Text) ;
    UpdateFile ;
  finally
    Free ;
  end ;
  RefreshAll ;
end;

procedure TINIForm.BitBtn2Click(Sender: TObject);
begin
  with TIniFile.Create(ExtractFilePath(Application.ExeName)+'Sample.ini') do
  try
    DeleteKey(ComboBox1.Text,ComboBox2.Text) ;
    UpdateFile ;
  finally
    Free ;
  end ;
  ComboBox2.Items.Delete(ComboBox2.ItemIndex) ;
  Memo1.Clear ;
  Memo1.Lines.LoadFromFile(ExtractFilePath(Application.ExeName)+'Sample.ini') ;
end;

end.
