CREATE TRIGGER NAUCZYCIELE_AFTER_UPDATE
AFTER UPDATE OF IMIE ON NAUCZYCIELE //po modyfikacji wartoci w kolumnie IMIE; jeli chcemy aby wyzwalacz odpowiada na dowoln modyfikacj wiersza usuwamy OF IMIE; 
// BEFORE warunek WHEN jest sprawdzany przed zajciem zdarzenia 
//INSTEAD OF jak BEFORE, ale zdarzenie nie nastpuje (akcja wyzwalacza jest wykonywana zamiast zdarzenia)
//AFTER warunek WHEN jest sprawdzany po zajciu zdarzenia
//ON DATABASE pozwoli zdefiniowa wyzwalacz aktywny dla zdarze w bazie danych
REFERENCING
OLD AS STARY_WIERSZ //posta starego wiersza przed modyfikacj (wystpuje rwnie w przypadku zdarzenia usuwania wiersza)
NEW AS NOWY_WIERSZ //posta nowego wiersza po modyfikacji (wystpuje rwnie w przypadku dodawania nowego wiersza)
//w przypadku braku klauzuli FOR EACH ROW klauzule OLD_TABLE AS STARE_WIERSZE, NEW_TABLE AS NOWE_WIERSZE umoliwiaj dostp do tabel zawierajcych wiersze przed zmianami oraz po zmianach
FOR EACH ROW //wyzwalacz dziaa po modyfikacji kadego wiersza w bazie nawet jeli zdarzenia modyfikujce wiersz pojawiaj si w wyniku jednej instrukcji SQL, jeli chcemy aby wyzwalacz dziaa po wszystkich modyfikacjach dotyczcych jednej instrukcji SQL opuszczamy FOR EACH ROW
WHEN (NOWY_WIERSZ.IMIE IS NULL) //jeli brak nowej wartoci w kolumnie IMIE wstaw IMIE=<Bezimienny>
BEGIN
UPDATE NAUCZYCIELE
SET IMIE=<Bezimienny> 
WHERE :NOWY_WIERSZ.ID=ID;
END TRIGGER NAUCZYCIELE_AFTER_UPDATE;
/
