CREATE OR REPLACE TYPE typ_oddzialu AS OBJECT (
   nr NUMBER(20),
   nazwa CHAR(50));
/

CREATE OR REPLACE TYPE typ_pracownik AS OBJECT(
   id RAW(16),
   nazwa CHAR(50),
   oddzial REF typ_oddzialu,
      STATIC FUNCTION tworz_pracownika
      (nazwa VARCHAR2, oddzial REF typ_oddzialu)
      RETURN typ_pracownik
);
/

CREATE OR REPLACE TYPE BODY typ_pracownik IS
   STATIC FUNCTION tworz_pracownika
   (nazwa VARCHAR2, oddzial REF typ_oddzial)
   RETURN typ_pracownik IS
    BEGIN
       RETURN typ_pracownik(SYS_GUID(),nazwa,oddzial);
    END;
END;
/

CREATE TABLE tabela_pracownikow OF typ_pracownik;

INSERT INTO tabela_pracownikow 
VALUES (typ_pracownik.tworz_pracownika('Jan Kowalski', NULL));
