//Autor: Wiesaw Dudek
//


unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ToolWin, StdCtrls;

type
  TStrinListForm = class(TForm)
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    Memo1: TMemo;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Edit1: TEdit;
    procedure ToolButton1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ToolButton3Click(Sender: TObject);
    procedure ToolButton4Click(Sender: TObject);
    procedure ToolButton5Click(Sender: TObject);
    procedure ToolButton6Click(Sender: TObject);
    procedure ToolButton2Click(Sender: TObject);
  private
    { Private declarations }
    strList: TStrings;
  public
    { Public declarations }
  end;

var
  StrinListForm: TStrinListForm;

implementation

{$R *.DFM}

procedure TStrinListForm.ToolButton1Click(Sender: TObject);
begin
   OpenDialog1.InitialDir:=ExtractFilePath(Application.ExeName);
   if OpenDialog1.Execute then
   begin
     strList.LoadFromFile(OpenDialog1.FileName);
   end;
end;

procedure TStrinListForm.FormCreate(Sender: TObject);
begin
   strList:=Memo1.Lines;
end;

procedure TStrinListForm.ToolButton3Click(Sender: TObject);
var str: TStringList;
begin
  //sortowanie nie jest dostpne w strList
  str:=TStringList.Create;
  try
    str.Assign(strList);
    str.Sort;
    strList.Assign(str);
  finally
    str.Free;
  end;
end;

procedure TStrinListForm.ToolButton4Click(Sender: TObject);
var str: TStringList;
    i : integer;
begin
  //usuwanie duplikatw
  str:=TStringList.Create;
  try
    //moliwe jedynie dla listy posortowanej
    str.Sorted:=true;
    str.Duplicates:=dupIgnore;
    str.Clear;
    for i:=1 to strList.Count do
      str.Add(strList.Strings[i-1]);
    strList.Assign(str);
  finally
    str.Free;
  end;
end;

procedure TStrinListForm.ToolButton5Click(Sender: TObject);
begin
   ShowMessage('Wartosc dla fmCreate: '+strList.Values[Edit1.text]);
end;

procedure TStrinListForm.ToolButton6Click(Sender: TObject);
var index: integer;
begin
  index:=strList.IndexOf(Edit1.text);
  if index<>-1 then ShowMessage('Znalazlem. Indeks: '+IntToStr(index))
  else ShowMessage('Nie znalazem elementu: '+Edit1.text);
end;

procedure TStrinListForm.ToolButton2Click(Sender: TObject);
begin
   SaveDialog1.InitialDir:=ExtractFilePath(Application.ExeName);
   if SaveDialog1.Execute then
   begin
     strList.SaveToFile(SaveDialog1.FileName);
   end;
end;

end.
