import javax.swing.table.AbstractTableModel;
import java.util.ArrayList;

public class CustomerTableModel extends AbstractTableModel {
	

//List to hold the current customer entities in the database:

	private ArrayList customerList = new ArrayList();

//Set the list of customers. When the list is changed all the listeners are notified. This is to notify the table to redraw itself:

	public void setCustomerList(ArrayList customerList) {
		this.customerList = customerList;
		fireTableDataChanged();
	}
	

//Remove a specific customer. When the list is changed all the listeners are notified:

	public void removeCustomer(int index) {
		customerList.remove(index);
		fireTableDataChanged();
	}
    

//Get a specific customer:

    	public Customer getCustomer(int index) {
        
        	if(index >= customerList.size()) {
         	   return null;
        	}
        	return (Customer)customerList.get(index);
    	}

//Callback method to get the number of rows to be rendered in the table:

	public int getRowCount() {
		return customerList.size();
	}

//Callback method to get the number of columns to be rendered in the table:

	public int getColumnCount() {
		return 7;
	}

//Callback method to get the value of the specified cell to be rendered in the table:
	public Object getValueAt(int row,int col) {
		
		if(row >= customerList.size()) {
			throw new IllegalArgumentException("Invalid row");
		}
		
		Customer customer = (Customer)customerList.get(row);
		switch(col) {
			case 0:
				return customer.getTitle();
			case 1:
				return customer.getFname();
			case 2:
				return customer.getLname();
            	case 3:
                		return customer.getAddressLine();
            	case 4:
                		return customer.getTown();
            	case 5:
                		return customer.getZipCode();
            	case 6:
                		return customer.getPhone();
			default:
				throw new IllegalArgumentException("Invalid column");
		}
		
	}
    	
}
