import javax.swing.table.AbstractTableModel;
import java.util.ArrayList;
public class ItemTableModel extends AbstractTableModel {

private ArrayList itemList = new ArrayList();

   public void setItemList(ArrayList itemList) {
      this.itemList = itemList;
      fireTableDataChanged();
   }

   public void removeItem(int index) {
      itemList.remove(index);
      fireTableDataChanged();
   }

public Item getItem(int index) {

      if(index >= itemList.size() || index < 0) {
         return null;
      }
      return (Item)itemList.get(index);
   }

public int getRowCount() {
      return itemList.size();
   }

public int getColumnCount() {
      return 3;
   }

public Object getValueAt(int row,int col) {
      if(row >= itemList.size()) {
         throw new IllegalArgumentException("Niewaciwy wiersz");
      }
      Item item = (Item)itemList.get(row);
      switch(col) {
         case 0:
            return item.getDescription();
         case 1:
            return new Double(item.getCostPrice());
         case 2:
            return new Double(item.getSellPrice());
         default:
            throw new IllegalArgumentException("Niewaciwa kolumna");
      }
   }
}
