import javax.swing.JTable;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JPanel;
import javax.swing.JButton;

import java.awt.BorderLayout;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowAdapter;

import java.util.ArrayList;

import java.sql.DriverManager;
import java.sql.Connection;
import java.sql.Statement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ItemApp extends JFrame implements ActionListener {

   private ItemTableModel model;
   private JTable table;
   private Connection con;
   private ItemPanel itemPanel;
   public ItemApp(String[] arg) throws Exception {
      super("System zarzdzania magazynem");

   getConnection();

   model = new ItemTableModel ();
   refreshData();

   table = new JTable(model);
   table.setAutoCreateColumnsFromModel(true);
   JScrollPane pane = new JScrollPane(table);

   getContentPane().setLayout(new BorderLayout());

   getContentPane().add(pane,BorderLayout.CENTER);

   JPanel buttonPanel = new JPanel();
   JButton newButton = new JButton("Dodaj towar");
   newButton.addActionListener(this);
   buttonPanel.add(newButton);
   JButton deleteButton = new JButton("Usu towar");
   deleteButton.addActionListener(this);
   buttonPanel.add(deleteButton);
   getContentPane().add(buttonPanel,BorderLayout.SOUTH);

   itemPanel = new ItemPanel();
   getContentPane().add(itemPanel,BorderLayout.WEST);

   pack();
   show();
   setLocation(50,50);
   setSize(800,375);
   setResizable(false);
   validate();

  addWindowListener(new WindowAdapter() {
     public void windowClosing(WindowEvent e) {
       try {
         con.close();
       } catch(SQLException ex) {
          ex.printStackTrace();
       }
         System.exit(0);
     }
   });
  }
  public static void main(String args[]) throws Exception {
    ItemApp app = new ItemApp(args);
   }

   public void actionPerformed(ActionEvent e) {
      JButton button = (JButton)e.getSource();
      try {

if("Dodaj towar".equals(button.getText())) {
     addItem();
     }else if("Usu towar".equals(button.getText())) {
       removeItem();
     }
   }catch(SQLException ex) {
     ex.printStackTrace();
   }
   validate();
}

private void getConnection() throws Exception {
      Class.forName("org.gjt.mm.mysql.Driver");
      String url = "jdbc:mysql://localhost:3306/bmsimple";
      con = DriverManager.getConnection(url);
   }

private void refreshData() throws SQLException {
      String sql = "select * from item";
      Statement stmt = con.createStatement();
      ResultSet res = stmt.executeQuery(sql);
      ArrayList list = new ArrayList();
      while(res.next()) {
         Item item = new Item(
            res.getInt(1),
            res.getString(2),
            res.getDouble(3),
            res.getDouble(4));
            list.add(item);
      }
      model.setItemList(list);
      res.close();
      stmt.close();
   }

private void addItem() throws SQLException {
      String sql = "insert into item (" +
         "description,cost_price,sell_price)" +
         "values(" +
         "?,?,?)";

PreparedStatement stmt = con.prepareStatement(sql);
      Item item = itemPanel.getItem();
      if(item == null) return;

stmt.setString(1,item.getDescription());
      stmt.setDouble(2,item.getCostPrice());
      stmt.setDouble(3,item.getSellPrice());

stmt.executeUpdate();
      stmt.close();

refreshData();
      itemPanel.reset();
   }

private void removeItem() throws SQLException {
      String sql = "delete from item where item_id = ?";
      PreparedStatement stmt = con.prepareStatement(sql);

      int selectedRow = table.getSelectedRow();
      Item item = model.getItem(selectedRow);
      if(item == null) {
         return;
      }

stmt.setInt(1,item.getItemId());

stmt.executeUpdate();
      stmt.close();

      model.removeItem(selectedRow);
   }
}




 
