#!/usr/bin/perl -wT

use strict;

use DBI;
use CGI;

#przydatne przy uruchamianiu - wysyanie komunikatw o bdach do przegldarki
use CGI::Carp qw(fatalsToBrowser);

use vars qw($DBH $CGI);

$DBH = 
DBI->connect("DBI:mysql:bmsimple;mysql_read_default_file=/etc/bmsimple.cnf")
     or die "Bd poczenia: " . $DBI::errstr;

$CGI = new CGI();

if ($CGI->param( "submit_feedback" ) ) {
   add_feedback_to_database( $CGI, $DBH );
}
else {
   display_suggestion_page( $CGI, $DBH );
}

sub add_feedback_to_database {
   my $cgi = shift;
   my $dbh = shift;
   my ($suggestion_text,$customer_name,$email,$item_name, 
       $satisfaction_val, $field_list, $value_list, $sql);

   $suggestion_text   = $cgi->param("comments");
   $customer_name     = $cgi->param("customer_name");
   $email             = $cgi->param("client_email");
   $item_name         = $cgi->param("item_name");
   $satisfaction_val  = $cgi->param("how_good");

   #przygotowanie zapytania do wstawiania danych 
   $field_list = "('name','email','product','comments','sat_level')";
   $value_list = qq{ 
      "$customer_name","$email","$item_name",
      "$suggestion_text","$satisfaction_val"
   };

   $sql = qq{ INSERT INTO feedback VALUES($value_list)};
   $dbh->do($sql) or die "Bd wstawiania: " . $dbh->errstr();

   #Po dodaniu danych naley odwiey stron
   display_suggestion_page($cgi, $dbh);

} # koniec add_feedback_to_database

sub display_suggestion_page {

   my $cgi = shift;
   my $dbh = shift;

   my ( $option_val, $OPTION_STRING, $sth, $CUSTOMER_FEEDBACK,
      $comments, $name, $product);

   #tworzenie cigu zawierajcego list towarw
   #kada nazwa towaru powinna by umieszczona w znacznikach <OPTION> </OPTION>.
   $sth = $dbh->prepare("select description from item");
   $sth->execute();

   while ( ($option_val) = $sth->fetchrow_array()) {
      $OPTION_STRING .="<OPTION>$option_val</OPTION>\n";
   }
   $sth->finish();

   $sth = $dbh->prepare("select name,product,comments from feedback");
   $sth->execute();

   #tworzenie cigu zawierajcego wszystkie dotychczas otrzymane uwagi
   while ( ($name,$product,$comments) = $sth->fetchrow_array()) {
      $CUSTOMER_FEEDBACK .= qq{

         <TABLE BORDER=0 WRAP=256 CELLSPACING=0 CELLPADDING=0 COLS=1
         ROWS=2 BGCOLOR="#ffcb32">
         <TR><TD>

         <P STYLE="COLOR: #070568; TEXT-DECORATION: none; ">
         $name powiedzia o $product: 
         </P>
         </TD></TR>
         <TR><TD bgcolor="white">
         $comments
         </TD></TR>
         </TABLE>
      }
   }

   #wysanie strony
   print "Content-type: text/html\n\n";
   print << "END_OF_HTML";
   <HTML>
   <HEAD>
   <TITLE>Formularz informacji od klientw</TITLE>
   </HEAD>
   <BODY BGCOLOR = "FFFFFF" TEXT = "000000">
   <TABLE WIDTH="100%" BGCOLOR="#ffcb32">
   <TR><TD>
   <H2>Co myslisz o naszych towarach?</H2>
   </TD></TR>
   </TABLE>
   <FORM ACTION = "http://localhost/cgi-bin/feedback.cgi" METHOD = "POST">

   <BLOCKQUOTE>

   <TABLE BORDER = "0">

   <TR>
   <TH ALIGN = "left">Klient:</TH>
   <TD>
   <INPUT TYPE = "text" NAME = "customer_name" SIZE = "35" MAXLENGTH = "35">
   </TD>
   </TR>

   <TR>
   <TH ALIGN = "left">Email:</TH>
   <TD>
   <INPUT TYPE = "text" NAME = "client_email" SIZE = "35" MAXLENGTH = "35">
   </TD>
   </TR>

   <TR>
   <TH ALIGN = "left">Produkt:</TH>
   <TD>
   <SELECT NAME=item_name>
   $OPTION_STRING
   </SELECT>
   </TD>
   </TR>

   <TR>
   <TH ALIGN = "left">Komentarz</TH>
   <TD>
   <TEXTAREA WRAP = "virtual" NAME = "comments" ROWS = "5" COLS = "40">
   </TEXTAREA>
   </TD>
   </TR>

   <TR>
   <TH ALIGN ="left">Okrel poziom zadowolenia</TH>
   <TD>
   <INPUT TYPE="radio" NAME="how_good" VALUE="5" CHECKED>Bardzo zadowolony</INPUT>
   <INPUT TYPE="radio" NAME="how_good" VALUE="4" >Zadowolony</INPUT>
   <INPUT TYPE="radio" NAME="how_good" VALUE="3" >W porzdku</INPUT>
   <INPUT TYPE="radio" NAME="how_good" VALUE="2" >Nie bardzo</INPUT>
   <INPUT TYPE="radio" NAME="how_good" VALUE="1" >Bardzo niezadowolony</INPUT>
   </TD>
   </TR>
   </TABLE>

   <P>

   <CENTER>
   <INPUT NAME="submit_feedback" TYPE = "submit" VALUE = "Przelij te informacje.">
   </CENTER>

   </BLOCKQUOTE>
   </FORM>

   <TABLE>
   <TR><TD><H3>Co powiedzieli inni klienci:</H3></TD></TR>
   </TABLE>

   $CUSTOMER_FEEDBACK

   </BODY>
   </HTML>
END_OF_HTML
}