#!/usr/bin/perl -w

use DBIx::Easy;
use strict;

sub myErrorHandler
{
   my( $statement, $err, $msg ) = @_;
   die"Bd, \"$statement\" nieudane ($err) - $msg";
}

# musimy jawnie okreli typ i nazwe bazy danych
my $conn = new DBIx::Easy("mysql", "bmsimple");

$conn->install_handler(\&myErrorHandler);

#process() jest podobny do do()
$conn->process("CREATE TABLE number(value INT(11), name CHAR(30))");

#Ponisze wyraenie moe byc czytane jako:
#insert into table name('name','value') values ('John','42')
$conn->insert("number", name => "John",         value => 42);
$conn->insert("number", name => "Harry",        value => 23);
$conn->insert("number", name => "Timothy",      value => 23);
$conn->insert("number", name => "Mary",         value => 22);
$conn->insert("number", name => "Thomas",       value => 42);

#zwraca referencj do tablicy asocjacyjnej z nazwami i wartociami,
# w ktrych value = 23
my $numbers = $conn->makemap("number", "name", "value", "value = 23");

print "Ponisze nazwy maj warto '23' skojarzon z nimi\n";
foreach my $name (keys(%$numbers)) {
   print $name, " ma warto ", $$numbers{$name}, "\n";
}

#dla wszystkich pl o wartoci 42, zmienione zostanie pole 'name'
# i bdzie miao warto "Zaphod"
$conn->update("number", "value = 42", name => "Zaphod");
print "dla wszystkich pl o wartoci 42, zmienione zostanie pole 'name' 
i bdzie miao warto 'Zaphod'. Sprawd to...\n";

#usunicie wszystkich pozycji o wartoci 23
$conn->process("DELETE FROM number WHERE value = 23");
print "Wszystkie wiersze zawierajce warto 23 zostay usunite, 
sprawd to ...\n";
