
create table customer
(
    customer_id                     int AUTO_INCREMENT NOT NULL PRIMARY KEY,
    title                           char(4)                       ,
    fname                           varchar(32)                   ,
    lname                           varchar(32)           NOT NULL,
    addressline                     varchar(64)                   ,
    town                            varchar(32)                   ,
    zipcode                         char(10)              NOT NULL,
    phone                           varchar(16)
) TYPE = InnoDB;

create table item
(
    item_id                         int AUTO_INCREMENT NOT NULL PRIMARY KEY,
    description                     varchar(64)           NOT NULL,
    cost_price                      numeric(7,2)                  ,
    sell_price                      numeric(7,2)
) TYPE = InnoDB;


create table orderinfo
(
    orderinfo_id                    int AUTO_INCREMENT NOT NULL PRIMARY KEY,
    customer_id                     integer               NOT NULL,
    date_placed                     date                  NOT NULL,
    date_shipped                    date                          ,
    shipping                        numeric(7,2),
    INDEX (customer_id),
    CONSTRAINT orderinfo_customer_id_fk FOREIGN KEY(customer_id) REFERENCES customer(customer_id)
) TYPE = InnoDB;

create table stock
(
    item_id                         integer               NOT NULL AUTO_INCREMENT PRIMARY KEY,
    quantity                        integer               NOT NULL,
    CONSTRAINT stock_item_id_fk FOREIGN KEY(item_id) REFERENCES item(item_id)
) TYPE = InnoDB;


create table orderline
(
    orderinfo_id                    integer               NOT NULL,
    item_id                         integer               NOT NULL,
    quantity                        integer               NOT NULL,
    PRIMARY KEY(orderinfo_id, item_id),
    INDEX(item_id),
    CONSTRAINT orderline_orderlinfo_id_fk FOREIGN KEY (orderinfo_id) REFERENCES orderinfo(orderinfo_id),
    CONSTRAINT orderline_item_id_fk FOREIGN KEY (item_id) REFERENCES item(item_id)
)  TYPE = InnoDB;

create table barcode
(
    barcode_ean                     char(13)              NOT NULL PRIMARY KEY,
    item_id                         integer               NOT NULL,
    INDEX(item_id),
    CONSTRAINT barcode_item_id_fk FOREIGN KEY(item_id) REFERENCES item(item_id)
)  TYPE = InnoDB;


