
create table customer
(
    customer_id                     int AUTO_INCREMENT NOT NULL PRIMARY KEY,
    title                           char(4)                       ,
    fname                           varchar(32)                   ,
    lname                           varchar(32)           NOT NULL,
    addressline                     varchar(64)                   ,
    town                            varchar(32)                   ,
    zipcode                         char(10)              NOT NULL,
    phone                           varchar(16)
);

create table item
(
    item_id                         int AUTO_INCREMENT NOT NULL PRIMARY KEY,
    description                     varchar(64)           NOT NULL,
    cost_price                      numeric(7,2)                  ,
    sell_price                      numeric(7,2)
);



create table orderinfo
(
    orderinfo_id                    int AUTO_INCREMENT NOT NULL PRIMARY KEY,
    customer_id                     integer               NOT NULL,
    date_placed                     date                  NOT NULL,
    date_shipped                    date                          ,
    shipping                        numeric(7,2)
);

create table stock
(
    item_id                         integer               NOT NULL AUTO_INCREMENT PRIMARY KEY,
    quantity                        integer               NOT NULL
);


create table orderline
(
    orderinfo_id                    integer               NOT NULL,
    item_id                         integer               NOT NULL,
    quantity                        integer               NOT NULL,
    PRIMARY KEY(orderinfo_id, item_id)
);

create table barcode
(
    barcode_ean                     char(13)              NOT NULL PRIMARY KEY,
    item_id                         integer               NOT NULL
);


