package com.bddinaction.chapter8.jbehave.flowsteps;

import com.bddinaction.chapter8.jbehave.pages.BookingPage;
import com.bddinaction.chapter8.jbehave.pages.LoginPage;
import net.thucydides.core.annotations.Step;

public class TravellerFlowSteps {

    LoginPage loginPage;
    BookingPage bookingPage;

    @Step
    public void navigateToFlightBookings() {
        loginPage.open();
        loginPage.inMainMenu().selectMenuOption("Rezerwacja");
    }

    @Step("Wyszukiwanie {0} lotów z {1} do {2} w klasie {3}")
    public void searchForFlights(String flightType, String from, String to, String travelClass) {
        bookingPage.setFlightType(flightType);
        bookingPage.setFrom(from);
        bookingPage.setTo(to);
        bookingPage.setTravelClass(travelClass);

        bookingPage.searchButton().shouldNotBeEnabled();

    }
}

