package com.bddinaction.chapter2.services

import com.bddinaction.chapter2.model.Line
import spock.lang.Specification
import spock.lang.Unroll

class WhenFindingLinesThroughStations extends Specification {

    @Unroll("Linia pomiędzy #departure a #destination powinna nazywać się #lineName i startować z #lineDeparture")
    def "powinna znaleźć prawidłowe linie pomiędzy dwoma stacjami"() {
        given:
            InMemoryTimetableService timetableService = new InMemoryTimetableService()
        when:
            List<Line> lines = timetableService.findLinesThrough(departure, destination);
        then:
            Line expectedLine = Line.named(lineName).departingFrom(lineDeparture);
            lines == [expectedLine]
        where:
            departure     | destination  | lineName  | lineDeparture
            "Parramatta"  | "Town Hall"  | "Western" | "Emu Plains"
            "Town Hall"   | "Parramatta" | "Western" | "North Richmond"
            "Strathfield" | "Epping"     | "Epping"  | "City"
    }
}

