package com.bddinaction.chapter12.cucumber.steps;

import com.bddinaction.chapter12.cucumber.steps.persona.FrequentFlyerPersona;
import com.bddinaction.chapter12.model.FrequentFlyer;
import com.bddinaction.chapter12.model.FrequentFlyerStatus;
import cucumber.api.java.en.Given;
import cucumber.api.java.en.Then;
import cucumber.api.java.en.When;

import static org.fest.assertions.Assertions.assertThat;

public class ZdobywanieStatus {

    private final FrequentFlyerHelper frequentFlyerHelper;

    public ZdobywanieStatus(FrequentFlyerHelper frequentFlyerHelper) {
        this.frequentFlyerHelper = frequentFlyerHelper;
    }

    @Given("^(.*) jest uczestnikiem programu Frequent Flyer$")
    public void a_Frequent_Flyer_member(FrequentFlyerPersona persona, FrequentFlyerStatus status) {
        FrequentFlyer member = persona.getFrequentFlyer();
        member.setStatus(status);
        frequentFlyerHelper.setFrequentFlyer(member);
        try {
            Thread.currentThread().sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Given("^ma punkty statusowe w liczbie (.*)$")
    public void earned_status_points(int statusPoints) {
        FrequentFlyer member = frequentFlyerHelper.getFrequentFlyer();
        member.setStatusPoints(statusPoints);
    }

    @When("^zdobędzie punkty statusowe w liczbie (.*)$")
    public void earn_extra_status_points(int points) {
        FrequentFlyer member = frequentFlyerHelper.getFrequentFlyer();
        member.earns(points).statusPoints();
        try {
            Thread.currentThread().sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Then("^powinien mieć status (.*)$")
    public void should_have_status_of(FrequentFlyerStatus expectedStatus) {
        FrequentFlyer member = frequentFlyerHelper.getFrequentFlyer();
        assertThat(member.getStatus()).isEqualTo(expectedStatus);
    }

}

