'use strict';

describe('Frequent Flyers', function() {

    var FrequentFlyer = require('../lib/frequent_flyer');
    var frequentFlyer;

    beforeEach(function() {
        frequentFlyer = new FrequentFlyer();
    });


    describe("Zarządzanie statusami uczestników programu Frequent Flyer", function() {
        it("powinen mieć początkowy status Brązowy", function() {
           expect(frequentFlyer.getStatus()).toBe('Brązowy');
        });

        it("powinien początkowo nie mieć punktów statusowych", function() {
            expect(frequentFlyer.getStatusPoints()).toBe(0);
        });

    });

    describe("Zbieranie punktów Frequent Flyer", function() {
       it('powinien zdobywać punkty za każdy lot', function() {

           frequentFlyer.earnStatusPoints(100);
           frequentFlyer.earnStatusPoints(50);

           expect(frequentFlyer.getStatusPoints()).toBe(150);
       });

        it('powinien aktualizować status uczestnika po zdobyciu wystarczającej liczby punktów', function() {

            frequentFlyer.earnStatusPoints(300);

            expect(frequentFlyer.getStatus()).toBe('Srebrny');
        });
    });
});

