package com.bddinaction.chapter10.model

import spock.lang.Specification

import static Status.*

class WhenManagingFrequentFlyerMemberStatusUpdates extends Specification {

    def "Uczestnik programu Frequent Flyer wymaga imienia, nazwiska i numeru uczestnika frequent flyer"() {
        when:
            def member = FrequentFlyer.withFrequentFlyerNumber("12345678").named("Janusz","Bloger")
        then:
            member.frequentFlyerNumber == "12345678"
        and:
            member.firstName == "Janusz"
        and:
            member.lastName == "Bloger"
    }

    def "nowy uczestnik programu frequent powinien mieć status Brazowy"() {
        given:
            def member = FrequentFlyer.withFrequentFlyerNumber("12345678").named("Janusz","Bloger")
        when:
            def status = member.status
        then:
            status == Status.Brazowy
    }


    def "powinien być w stanie zaktualizować status uczestnika programu Frequent Flyer"() {
        given:
            def member = FrequentFlyer.withFrequentFlyerNumber("12345678").named("Janusz","Bloger")
        when:
            def updatedMember = member.withStatus(Status.Srebrny)
        then:
            updatedMember.status == Status.Srebrny
    }

    def "uczestnik powinien mieć możliwość zdobycia dodatkowych punktów statusowych"() {
        given:
            def member = FrequentFlyer.withFrequentFlyerNumber("12345678").
                    named("Janusz","Bloger").
                    withStatusPoints(initialPoints)
        when:
            member.earns(additionalPoints).statusPoints()
        then:
            member.statusPoints == expectedPoints
        where:
            initialPoints | additionalPoints  | expectedPoints
            0             | 100               | 100
            100           | 50                | 150
    }
	
	

    def "powinien aktualizować status uczestnika po zdobyciu wystarczającej liczby punktów"() {
        given: "uczestnik programu frequent flyer z określoną liczbą punktów"
            def member = FrequentFlyer.withFrequentFlyerNumber("12345678").
                    named("Janusz","Bloger").
                    withStatusPoints(initialPoints).
                    withStatus(initialStatus)
        when: "zdobędzie dodatkowe punkty za lot"
            member.earns(extraPoints).statusPoints()
        then: "może uaktualnić swój status do nowego poziomu"
            member.getStatus() == expectedStatus
        where:
            initialStatus | initialPoints | extraPoints | expectedStatus
            Brazowy     | 0             | 299          | Brazowy
            Brazowy     | 0             | 300          | Srebrny
            Srebrny     | 0             | 699         | Srebrny
            Srebrny     | 0             | 700          | Zloty
            Zloty         | 0             | 1499        | Zloty
            Zloty         | 0             | 1500         | Platynowy
    }

}

