package com.bddinaction.chapter2.services

import com.bddinaction.chapter2.model.Line
import org.joda.time.LocalTime
import spock.lang.Specification

class WhenFindingArrivalTimeAtStations extends Specification {

    def timetableService = new InMemoryTimetableService()

    def "powinna znaleźć prawidłowe godziny przyjazdu pomiędzy dwoma stacjami"() {
        given: "pociągi linii Western z Emu Plains"
            def westernLine = Line.named("Western").departingFrom("Emu Plains")
        when: "czasy przyjazdu na stację Parramatta to"
            def arrivalTimes = timetableService.findArrivalTimes(westernLine, "Parramatta")
        then: "powinienem uzyskać informację o pociągach"
            arrivalTimes == [at(7,58), at(8,00), at(8,02), at(8,11), at(8,14), at(8,21)]
    }

    def at(int hour, int minute) {
        new LocalTime(hour, minute)
    }
}

