#!/bin/env ruby
# encoding: utf-8
require 'rspec'
require 'frequent_flyer'

describe FrequentFlyer do
  context 'gdy konto uczestnika programu frequent flyer jest tworzone po raz pierwszy' do
    it 'powinno mieć początkowy status Brązowy' do
      frequentFlyer = FrequentFlyer.new
      expect(frequentFlyer.status).to eq('BRĄZOWY')
    end
  end
  context 'gdy nowy uczestnik programu Frequent Flyer zaczyna latać liniami Flying High' do
    it 'powinien zdobywać punkty za każdy lot' do
      frequentFlyer = FrequentFlyer.new

      frequentFlyer.earn_status_points(100)

      expect(frequentFlyer.status_points).to eq(100)
    end

    it 'powinien aktualizować status uczestnika po zdobyciu wystarczającej liczby punktów' do
      frequentFlyer = FrequentFlyer.new

      frequentFlyer.earn_status_points(100).earn_status_points(200)

      expect(frequentFlyer.status).to eq('SREBRNY')
    end
  end
end
