#include "menu.h"
#include "ST7565/ST7565.h"
#include <stddef.h>
#include <string.h>
#include <avr\pgmspace.h>

static struct _menuitem *currMenuPtr;         //Bieca pozycja menu
static int8_t menuindex;                      //Numer aktualnie wybrane pozycji menu
static int8_t menufirstpos;                   //Numer pozycji menu wywietlanej w grnym rzdzie

void Menu_init()
{
	currMenuPtr=menu;
	menuindex=0;
	menufirstpos=0;
}

uint8_t Menu_GetMenuItemsNo()            //Policz ile dane menu ma pozycji
{
	struct _menuitem *tmpmenuitem=currMenuPtr;
	uint8_t index=0;

	while(tmpmenuitem)
	{
		tmpmenuitem=tmpmenuitem->next;
		index++;
	}
	return index;
}

struct _menuitem *Menu_GetMenuItem(uint8_t index)
{
	struct _menuitem *tmpmenuitem=currMenuPtr;

	while((tmpmenuitem) && (index>0))
	{
	 tmpmenuitem=tmpmenuitem->next;
	 index--;
	}
	return tmpmenuitem;
}

uint8_t Menu_GetMenuRows()
{
	return ST7565R_HEIGHT/(uint8_t)(uint16_t)Menu_font[0];
}

void Menu_Show()
{
	struct _menuitem *tmpmenuitem=Menu_GetMenuItem(menufirstpos);
	uint8_t font_height=(uint8_t)(uint16_t)Menu_font[0];
	uint8_t menuitemsno=Menu_GetMenuItemsNo();

	st7565r_Clear(false); //Wyczy LCD

	for(uint8_t i=0; i < Menu_GetMenuRows(); i++)
	{
		_Bool invert=menuindex == ((menufirstpos + i) % menuitemsno);              //Czy podwietli dan pozycje menu
		st7565r_SetText(0, i * font_height, tmpmenuitem->text, Menu_font, invert); //Wywietl pozycj menu
		if(tmpmenuitem->submenu)
		  st7565r_SetText(ST7565R_WIDTH - 3 * font_height, i * font_height, PSTR(">>>"), Menu_font, invert); //Zaznacz, e mamy submenu
		tmpmenuitem=tmpmenuitem->next;
		if(tmpmenuitem == NULL)  //Koniec listy
		{
			if(Menu_GetMenuItemsNo() > Menu_GetMenuRows()) tmpmenuitem=currMenuPtr; //Zawijamy list jeli jest dusza ni liczba wywietlanych pozycji
			   else break;   //lub koczymy, eby unikn powtarzania elementw
		}
	}
	st7565r_CpyDirtyPages();   //Odwie widok na LCD
}

void Menu_SelectNext()
{
	uint8_t no=Menu_GetMenuItemsNo();
	menuindex++;
	if(no > Menu_GetMenuRows())        //Czy liczba pozycji menu jest wiksza ni liczba wywietlanych pozycji?
		{
			int8_t dist;               //Odlego pomidzy pierwsz wywietlan pozycj, a pozycj podwietlon
			if(menuindex < menufirstpos) dist=no - menufirstpos + menuindex; //Jest zalena od tego, kta z pozycji jest wiksza
			   else dist=menuindex-menufirstpos;
			if(dist >= Menu_GetMenuRows()) menufirstpos++;  //Koniec ekranu, trzeba przewija
		}
	menuindex%=no;     //Liczymy wszysko modulo liczba pozycji w menu
	menufirstpos%=no;
	Menu_Show();      //Wywietl menu
}

void Menu_SelectPrev()
{
	if(menuindex > 0)
	{
		if(menuindex == menufirstpos) menufirstpos--;
		menuindex--;               //Poprzedni element
	}
	 else
	{
		if(menufirstpos == 0)
		{
			menuindex=Menu_GetMenuItemsNo()-1;  //Zawijamy menu
			if(Menu_GetMenuItemsNo()>Menu_GetMenuRows()) menufirstpos=menuindex;  //Jeli mamy mniej pozycji menu ni linii na LCD to nie zmieniamy numeru pierwszej pozycji menu
		} else menuindex=Menu_GetMenuItemsNo()-1;
	}
	Menu_Show();     //Wywietl menu
}

void Menu_Back(struct _menuitem *ptritem)
{
	menufirstpos=0;
	menuindex=0;
	currMenuPtr=ptritem->parent;
}

void Menu_GoSubMenu()
{
	struct _menuitem *tmpmenuitem=Menu_GetMenuItem(menuindex);
	struct _menuitem *submenu=tmpmenuitem->submenu;
	if(submenu)
	{
		currMenuPtr=submenu;
		menuindex=0;
		menufirstpos=0;
	}
	Menu_Show();
}

void Menu_Click()
{
	struct _menuitem *tmpmenuitem=Menu_GetMenuItem(menuindex);
	struct _menuitem *submenu=tmpmenuitem->submenu;

    menuitemfuncptr mfptr=tmpmenuitem->menuitemfunc;
	if(mfptr) (*mfptr)(tmpmenuitem);
	if(submenu)
	{
		currMenuPtr=submenu;
		menuindex=0;
		menufirstpos=0;
	}
	Menu_Show();
}
