/*
* mp3_DMA.c
*
* Created: 2013-10-07 20:50:35
*  Author: tmf
*/


#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <util/delay.h>
#include <string.h>
#include "VS1003B.h"
#include "st7565/ST7565.h"
#include "KBD.h"
#include "SD.h"
#include "menu.h"
#include "Menu-GFX.h"
#include "Pics.h"
#include "VS_Recorder.h"
#include "VS_Player.h"

//Uchwyty do tablic czcionek
extern const __flash uint8_t* const __flash system16_array[];
extern const __flash uint8_t* const __flash system12_array[];
extern const __flash uint8_t* const __flash system8_array[];

void Menu_Tools_Init(const struct _menuitem_gfx *ptritem);
void Menu_Player(const struct _menuitem_gfx *ptritem);
void Menu_Recorder(const struct _menuitem_gfx *ptritem);

struct _menuitem_gfx const __flash menu_tools = {image_data_tools, Menu_Tools_Init, 0, 0, 0};
struct _menuitem_gfx const __flash menu_microphone = {image_data_microphone, Menu_Recorder, 0, 0, &menu_tools};
const __flash struct _menuitem_gfx const __flash menu_gfx = {image_data_headphones, Menu_Player, 0, 0, &menu_microphone};


const __flash uint8_t* const __flash *Menu_font = system8_array;  //Czcionka uywana do wywietlenia menu

struct _menuitem *menu;                  //Struktura wywietlanego menu
FATFS fatfs;                             //System plikw na karcie
_Bool MenuMainLoopExit;                  //Flaga przerywajca dziaanie funkcji Menu_Run()


void Player_NoCard()
{
	st7565r_Clear(false);        //Wyczy ekran
	st7565r_SetText(0, 8, PSTR("No card!"), system16_array, false);
	st7565r_CpyDirtyPages();    //Aktualizacja ekranu
	while(SD_CardInit() == false);
	st7565r_Clear(false);        //Wyczy ekran
	st7565r_CpyDirtyPages();    //Aktualizacja ekranu
}

struct _menuitem menutools;

VS_SampeRate_t VS_SampleRate[]={{"Sample rate: 8000", SAMPLERATE(8000)}, {"Sample rate: 16000", SAMPLERATE(16000)},
	                            {"Sample rate: 32000", SAMPLERATE(32000)}, {"Sample rate: 41000", SAMPLERATE(41000)}};
char *VS_LineIn[]={"Microphone", "Line in"};

void Menu_Player(const struct _menuitem_gfx *ptritem)
{
	if(menu == NULL) Menu_ReScan();   //Odczytaj katalog jeli nie robilimy tego wczeniej
	Menu_init();     //Zainicjuj obsuge menu
	Menu_Show();     //Poka menu
	Menu_Run();      //Gwna ptla menu
}

void MenuTools_SamplerateFunc(struct _menuitem *ptritem)
{
	VS_Settings.samplerateindex=(VS_Settings.samplerateindex + 1) % (sizeof(VS_SampleRate)/sizeof(VS_SampleRate[0]));
	menutools.text=VS_SampleRate[VS_Settings.samplerateindex].txt;
}

void MenuTools_InputSelFunc(struct _menuitem *ptritem)
{
	VS_Settings.LineIn=!VS_Settings.LineIn;
	ptritem->text=VS_LineIn[VS_Settings.LineIn];
};

void MenuMainLoop_Back(struct _menuitem *ptritem)
{
	MenuMainLoopExit=true;
}

struct _menuitem menutools={NULL, MenuTools_SamplerateFunc, NULL, NULL, NULL,     //Info o samplerate
	&(struct _menuitem){NULL, MenuTools_InputSelFunc, NULL, NULL, NULL,           //Info o wybranym wejciu rec
		&(struct _menuitem){"Back", MenuMainLoop_Back, NULL, NULL, NULL, NULL}}};

void Menu_Tools_Init(const struct _menuitem_gfx *ptritem)
{
	menutools.text=VS_SampleRate[VS_Settings.samplerateindex].txt;
	menutools.next->text=VS_LineIn[VS_Settings.LineIn];

	struct _menuitem *tmpmenu=menu;
	menu=&menutools;
	Menu_init();     //Zainicjuj obsuge menu
	Menu_Show();     //Poka menu
	Menu_Run();
	menu=tmpmenu;
}

void MenuGFX_Run()
{
	uint8_t OldButtons=Buttons;  //Poprzedni stan klawiszy

	while(1)
	{
		uint8_t tmpbtn=Buttons;
		if(((tmpbtn ^ OldButtons) & 1) && (tmpbtn & 1)) MenuGFX_Click();       //Wcinity SW0
		if(((tmpbtn ^ OldButtons) & 2) && (tmpbtn & 2)) MenuGFX_SelectPrev();  //Wcinity SW1
		if(((tmpbtn ^ OldButtons) & 4) && (tmpbtn & 4)) MenuGFX_SelectNext();  //Wcinity SW2
		OldButtons=tmpbtn;
	}
}

void Show_Main_Menu()
{
	MenuGFX_Show();
	MenuGFX_Run();
}

bool OSC_wait_for_rdy(uint8_t clk)
{
	uint8_t czas=255;
	while ((!(OSC.STATUS & clk)) && (--czas)) // Czekaj na ustabilizowanie si generatora
	_delay_ms(1);
	return czas;   //false jeli generator nie wystartowa, true jeli jest ok
}

void SelectPLL(OSC_PLLSRC_t src, uint8_t mult)
{
	mult&=OSC_PLLFAC_gm;
	OSC.PLLCTRL=src | mult;              //Ustaw rdo i mnonik PLL
	OSC.CTRL|=OSC_PLLEN_bm;				 //Wcz ukad PLL
	OSC_wait_for_rdy(OSC_PLLRDY_bm);     //Poczekaj na ustabilizowanie si PLL
}

int main(void)
{
	SelectPLL(OSC_PLLSRC_RC2M_gc, 15);  //Zwikszamy taktowanie - potrzebujemy >4 MHz
	CPU_CCP=CCP_IOREG_gc;               //Odblokuj zmian konfiguracji
	CLK.CTRL=CLK_SCLKSEL_PLL_gc;        //Wybierz PLL

	VS1003_init();           //Inicjalizacja VS1003B i portu z nim zwizanego
	st7565r_SPI_init();      //Inicjalizacja portu SPI (USARTD0) zwizanego z LCD
	st7565r_init();          //i samego LCD
	LCD_BackLight_Init();    //oraz jego podwietlenia
	st7565r_Clear(false);    //Wyczy LCD
	st7565r_CpyDirtyPages(); //Uaktualnij LCD
	Kbd_init();              //Zainicjuj obsuge klawiszy
	SD_SPI_init();           //Zainicjuj interfejs SPI uywany przez kart SD

	PMIC_CTRL=PMIC_LOLVLEN_bm | PMIC_MEDLVLEN_bm; //Odblokuj wybrane przerwania
	sei();

	Player_NoCard();         //Zainicjuj kart SD, a jeli jej nie ma wywietl finformacj
	f_mount(0, &fatfs);      //Dostp do systemu plikw

	Show_Main_Menu();        //Odczytaj biecy katalog

	while(1) {}
}