#ifndef _MENU_H
#define _MENU_H

#include <stdbool.h>
#include <stdint.h>

struct _menuitem;
typedef void (*menuitemfuncptr)(struct _menuitem *ptritem);

struct _menuitem
{
	char * text;
	menuitemfuncptr menuitemfunc;
	void *ptr;                    //Wskanik na dane uytkownika powizane z menu
	struct _menuitem *parent;
	struct _menuitem *submenu;
	struct _menuitem *next;
};

void Menu_init();
void Menu_Show();
void Menu_SelectNext();             //Przejd do kolejnej pozycji
void Menu_SelectPrev();             //Przejd do poprzedniej pozycji
void Menu_Click();                  //Obsu kliknicie na pozycj menu
void Menu_GoSubMenu();              //Wejd do podmenu jeli istnieje, ale bez wykonywania funkcji callback z menu nadrzdnego
void Menu_Back(struct _menuitem *ptritem);
void Menu_Free(struct _menuitem *ptr);   //Zwolnij pami przydzielon menu

extern struct _menuitem *menu;                              //Struktura menu
extern const __flash uint8_t* const __flash *Menu_font;     //Czcionka uywana przez menu

#endif
