/*
 * VS1003B.h
 *
 * Created: 2013-10-27 14:45:01
 *  Author: tmf
 */


#ifndef VS1003B_H_
#define VS1003B_H_

#define VS_WRITE_CMD    0x02   //Polecenie zapisu rejestru
#define VS_READ_CMD     0x03   //Polecenie odczytu rejestru
#define VS_MODE         0x00   //Kontrola trybu pracy
#define VS_STATUS       0x01   //Rejestr stanu
#define VS_BASS         0x02   //Regulacja basw
#define VS_CLOCKF       0x03   //Konfiguracja zegara i PLL
#define VS_DECODE_TIME  0x04   //Czas utworu w ms
#define VS_AUDATA       0x05   //Dane audio
#define VS_WRAM         0x06   //Zapis/odczyt RAM
#define VS_WRAMADDR     0x07   //Adres bazowy dla operacji R/W na RAM
#define VS_HDAT0        0x08   //Nagwek w trybie strumieniowym
#define VS_HDAT1        0x09   //Nagwek w trybie strumieniowym
#define VS_AIADDR       0x0A   //Adres startowy aplikacji uytkownika
#define VS_VOL          0x0B   //Kontrola gonoci
#define VS_AICTRL0      0x0C   //Rejestr kontroli aplikacji 0
#define VS_AICTRL1      0x0D   //Rejestr kontroli aplikacji 1
#define VS_AICTRL2      0x0E   //Rejestr kontroli aplikacji 2
#define VS_AICTRL3      0x0F   //Rejestr kontroli aplikacji 3

//Rejestry GPIO - dostp przez rejestry WRAMADDR i WRAM
#define VS_GPIO_DIR     0xc017  //Rejestr kierunku GPIO (1 - out, bity 0-3)
#define VS_GPIO_IN      0xc018  //Odczyt danych z GPIO
#define VS_GPIO_OUT     0xc019  //Zapis danych do GPIO

typedef struct                 //Tryby pracy ukadu
{
	_Bool SM_DIFF         : 1;
	_Bool SM_SETTOZERO    : 1;
	_Bool SM_RESET        : 1;
	_Bool SM_OUTOFWAV     : 1;
	_Bool SM_PDOWN        : 1;
	_Bool SM_TESTS        : 1;
	_Bool SM_STREAM       : 1;
	_Bool SM_SETTOZERO2   : 1;
	_Bool SM_DACT         : 1;
	_Bool SM_SDIORD       : 1;
	_Bool SM_SDISHARE     : 1;
	_Bool SM_SDINEW       : 1;
	_Bool SM_ADPCM        : 1;
	_Bool SM_ADPCM_HP     : 1;
	_Bool SM_LINE_IN      : 1;
} VS_SCI_MODE;

typedef struct                 //Rejestr stanu ukadu
{
	uint8_t SS_AVOL       : 2;
	_Bool   SS_APDOWN1    : 1;
	_Bool   SS_APDOWN2    : 1;
	uint8_t SS_VER        : 3;
} VS_SCI_STATUS;;

typedef struct                 //Rejestr kontroli basw
{
	uint8_t SB_FREQLIMIT  : 4;
	uint8_t SB_AMPLITUDE  : 4;
	uint8_t ST_FREQLIMIT  : 4;
	uint8_t ST_AMPLITUDE  : 4;
} VS_SCI_BASS;

//Stae wyboru preskalera
typedef enum {SC_MULT_XTAL10 = 0, SC_MULT_XTAL15 = 1, SC_MULT_XTAL20 = 3, SC_MULT_XTAL25 = 3, SC_MULT_XTAL30 = 4,
SC_MULT_XTAL35 = 5, SC_MULT_XTAL40 = 6, SC_MULT_XTAL45 = 7} SC_MULT_t;

//Czy mona czasowo zwikszy taktowanie?
typedef enum {SC_ADD_NoModificationAllowed = 0, SC_ADD_Mod05 = 1, SC_ADD_Mod10 = 2, SC_ADD_Mod15 = 3} SC_ADD_t;

typedef struct                 //Rejestr kontroli zegara
{
	uint16_t  SC_FREQ     : 11;
	uint8_t   SC_ADD      : 2;
	SC_MULT_t SC_MULT     : 3;
} VS_SCI_CLOCKF;

#define VS_HDAT0_WAV    0x7761U
#define VS_HDAT1_WAV    0x7665U
#define VS_HDAT1_WMA    0x574DU
#define VS_HDAT1_MIDI   0x4D54U

typedef struct
{
	uint8_t emphasis      : 2;
	_Bool   original      : 1;
	_Bool   copyright     : 1;
	uint8_t mode          : 2;
	_Bool   private       : 1;
	_Bool   pad_bit       : 1;
	uint8_t samplerate    : 2;
	uint8_t bitrate       : 4;
} CS_MP3_HDAT0;

typedef struct
{
	_Bool    protect_bit  : 1;
	uint8_t  layer        : 2;
	uint8_t  ID           : 2;
	uint16_t syncword     : 11;
} CS_MP3_HDAT1;

#endif /* VS1003B_H_ */