/*
 * SimpleFS.c
 *
 * Created: 2013-05-12 12:40:33
 *  Author: tmf
 */

#include "SimpleFS.h"
#include "DataFLASH.h"
#include "SPI.h"
#include "AT45CMD.h"
#include <string.h>


//Prywatne funkcje moduu
static __uint24 MS_GetFirstAvailPos();                       //Pierwsza wolna komrka pamici
static __uint24 MS_GetRegItem(const char *name);             //Sprawd czy rekord o podanej nazwie istnieje, jeli tak to zwr jego adres
static bool MS_CreateRegEntry(const char *name, __uint24 size); //Dodaj rekord do koca danych
static void MS_WritePages(__uint24 addr, void *Data, __uint24 size);   //Funkcja zapisuje size bajtw znajdujcych si w Data, w pamici poczwszy od adresu addr. Rozmieszczenie danych na stronie pamici jest bez znaczenia

void MS_Format()
{
    uint8_t Bufor[sizeof(SPI_Transact) + 4];                     //Bufor na polecenie
    DataFlash_AddTransaction(0xC7, 0, 0x94809A, Bufor, 0, true); //Skasuj cay ukad
	DataFLASH_WaitForReady();                                    //Zaczekaj na koniec operacji
}

bool MS_AddEntry(const char *name, __uint24 size)
{
	__uint24 addr=MS_GetRegItem(name);                           //Sprawd czy dany plik ju istnieje
	if(addr==(__uint24)-1) if(MS_CreateRegEntry(name, size)==false) //Nie ma podanego wpisu, wic tworzymy nowy
	                return false;  //Jeli bd to wracamy
	return true;
}

__uint24 MS_GetRegItem(const char *name)
{
	__uint24 addr=0;
	uint16_t asize=sizeof(SimpleFSEntry) + SimpleFS_MAXFileName; //Ile bajtw odczyta
	uint8_t Bufor[sizeof(SPI_Transact)  + asize + 4]; //Bufor na transakcj
	SPI_Transact *SPItrans=(SPI_Transact*)Bufor;
	SimpleFSEntry *FSEntry=((SimpleFSEntry*)&SPItrans->data[4]);

	do
	{
    	DataFlash_AddTransaction(AT45DBX_CMDA_RD_ARRAY_LF_SM, addr, Bufor, asize, true); //Odczytaj dane rekordu z pamici
		if(strcmp(FSEntry->Name, name)==0) return addr; //Rekord znaleziony
		addr+=FSEntry->Length;                          //Rekord nieznaleziony - przejd do kolejnej pozycji
	} while(FSEntry->Length!=-1);                       //Dugo rekordu ==-1 oznacza koniec acucha plikw
	return -1;         //Rekord nieznaleziony
}

bool MS_CreateRegEntry(const char *name, __uint24 size)
{
	__uint24 addr=MS_GetFirstAvailPos();
	if(addr==-1) return false;	//Bd - brak miejsca w pamici
	uint8_t FSRecSize=sizeof(SimpleFSEntry) + strlen(name)+1;        //Dugo rekordu
	if((DataFLASHSize - addr) < (size + FSRecSize)) return false;    //Sprawd czy mamy wystarczajc ilo pamici

	uint8_t Buf1[FSRecSize];                      //Miejsce na tymczasow struktur przechowujc dane rekordu
	SimpleFSEntry *TmpFSEntry=(SimpleFSEntry*)Buf1;
	TmpFSEntry->Length=size + FSRecSize;          //Dugo zapisywanego bloku danych
	TmpFSEntry->DataOffset=FSRecSize;             //Przesunicie do pierwszego bajtu danych w rekordzie
	strcpy(TmpFSEntry->Name, name);               //Nazwa pliku
	MS_WritePages(addr, Buf1, FSRecSize);         //Zapisz dane do DataFLASH
	return true;
}

void MS_WritePages(__uint24 addr, void *Data, __uint24 size)
{
	uint16_t bufsize=DataFLASH_PageSize;
	if(size < bufsize) bufsize=size;     //Oblicz jaki minimalny bufor jest potrzebny
	bufsize+=sizeof(SPI_Transact) + 4;
	uint8_t Buf[bufsize];                //Tymczasowe miejsce na pakiet
	SPI_Transact *SPItrans=(SPI_Transact*)Buf;
	__uint24 dataaddr=0;                 //Przesunicie w buforze danych do zapisu

	while(size)
	{
		DataFlash_AddTransaction(AT45DBX_CMDB_XFR_PAGE_TO_BUF1, addr, Buf, 0, true); //Przepisz dane z pamici do bufora 1 DataFLASH

		uint16_t offset=addr % DataFLASH_PageSize;    //Wylicz przesunicie na pierwszej zapisywanej stronie
		uint16_t asize=DataFLASH_PageSize - offset;
		if(asize>size) asize=size;                    //Zapisujemy nie wicej ni size bajtw

		DataFLASH_WaitForReady();

		memcpy(&SPItrans->data[4], &((uint8_t*)Data)[dataaddr], asize);   //Przepisz dane o rekordzie do bufora wysyanego do pamici
		DataFlash_AddTransaction(AT45DBX_CMDC_WR_BUF1, offset, Buf, asize, true); //Zapisz dane do bufora 1 DataFLASH

		DataFlash_AddTransaction(AT45DBX_CMDB_PR_BUF1_TO_PAGE_ER, addr, Buf, 0, true); //Zapisz dane z bufora 1 do DataFLASH
		DataFLASH_WaitForReady();
		size-=asize;
		addr+=asize;
		dataaddr+=asize;
	};
}

__uint24 MS_GetFirstAvailPos()
{

	__uint24 addr=0;  //Pocztek pamici
	uint16_t asize=sizeof(SPI_Transact) + sizeof(SimpleFSEntry) + 4; //Ile bajtw odczyta
	uint8_t Bufor[asize]; //Bufor na transakcj
	SPI_Transact *SPItrans=(SPI_Transact*)Bufor;
	SimpleFSEntry *FSEntry=((SimpleFSEntry*)&SPItrans->data[4]);

	while(1)
	{
		DataFlash_AddTransaction(AT45DBX_CMDA_RD_ARRAY_LF_SM, addr, Bufor, sizeof(SimpleFSEntry), true); //Odczytaj dane rekordu z pamici
		if(FSEntry->Length==-1) return addr;
		if((addr+FSEntry->Length)==-1) return -1;  //Bd - brak pamici
		addr+=FSEntry->Length;        //Adres kolejnego rekordu
	}
}

bool MS_Open(const char *name, SimpleFSHandle *Handle)
{
	__uint24 addr=MS_GetRegItem(name);
	if(addr==-1) return false;

	uint16_t asize=sizeof(SimpleFSEntry); //Ile bajtw odczyta
	uint8_t Bufor[sizeof(SPI_Transact)  + asize + 4]; //Bufor na transakcj
	SPI_Transact *SPItrans=(SPI_Transact*)Bufor;
	SimpleFSEntry *FSEntry=((SimpleFSEntry*)&SPItrans->data[4]);

   	DataFlash_AddTransaction(AT45DBX_CMDA_RD_ARRAY_LF_SM, addr, Bufor, asize, true); //Odczytaj dane rekordu z pamici

	Handle->Pos=0;
	Handle->Size=FSEntry->Length-FSEntry->DataOffset;  //Dugo pola danych (bez nagwka i nazwy rekordu
	Handle->Start=FSEntry->DataOffset+addr;            //Adres pierwszego bajtu danych
	return true;
}

void MS_Seek(SimpleFSHandle *Handle, __int24 position, FS_SeekMode mode)
{
	switch (mode)
	{
		case SEEK_SET:  Handle->Pos=position; break;
		case SEEK_CUR:  Handle->Pos+=position; break;
	}
	if(Handle->Pos > Handle->Size)
	{
	  if(position > 0) Handle->Pos=Handle->Size;  //Pozycja nie moe by powyej koca pliku
	     else Handle->Pos=0;                      //ani nie moe by przed jego pocztkiem
	}
}

__uint24 MS_WriteData(SimpleFSHandle *Handle, void *Data, __uint24 size)
{
	if((Handle->Pos + size) > Handle->Size) size=Handle->Size - Handle->Pos; //Nie moemy zapisa wicej bajtw ni zostao do koca pliku
    MS_WritePages(Handle->Start + Handle->Pos, Data, size);
	MS_Seek(Handle, size, SEEK_CUR);  //Ustaw now pozycj po zakoczeniu zapisu
	return size;         //Zwr liczb rzeczywicie zapisanych bajtw
}

__uint24 MS_ReadData(SimpleFSHandle *Handle, void *Bufor, __uint24 size)
{
	size=((Handle->Size - Handle->Pos) > size) ? size : (Handle->Size - Handle->Pos); //Oblicz ile rzeczywicie naley odczyta bajtw
	uint8_t Buf[sizeof(SPI_Transact) + 4 + size]; //Bufor tymczasowy
	SPI_Transact *trans=(SPI_Transact*)&Buf;
	uint8_t dato=DataFlash_AddTransaction(AT45DBX_CMDA_RD_ARRAY_LF_SM, Handle->Start + Handle->Pos, Buf, size, true); //Odczytaj dane rekordu z pamici
	memcpy(Bufor, &trans->data[dato], size);  //Przepisz dane z bufora transakcji do bufora dostarczonego przez aplikacj
	MS_Seek(Handle, size, SEEK_CUR);  //Ustaw now pozycj odczytu
	return size;                      //Zwr liczb odczytanych bajtw
}

bool MS_GetDirPos(__uint24 *addr, __uint24 *size, char *name, uint8_t bufsize)
{
	uint8_t Buf[sizeof(SPI_Transact) + 4 + bufsize + sizeof(SimpleFSEntry)]; //Bufor tymczasowy
	SPI_Transact *trans=(SPI_Transact*)&Buf;
	uint8_t dato=DataFlash_AddTransaction(AT45DBX_CMDA_RD_ARRAY_LF_SM, *addr, Buf, sizeof(SimpleFSEntry) + bufsize, true); //Odczytaj dane rekordu z pamici
	SimpleFSEntry *sfse=(SimpleFSEntry*)&trans->data[dato];
	if(sfse->Length == (__uint24)-1) return false;   //Nie ma wicej pozycji

	if((sfse->DataOffset - sizeof(SimpleFSEntry)) < bufsize) bufsize=sfse->DataOffset - sizeof(SimpleFSEntry); //Nie kopiuj wicej bajtw ni ma bufor
	memcpy(name, sfse->Name, bufsize);
	name[bufsize-1]=0;                     //Wpisz NULL jeli bufor krtszy ni nazwa
	*addr=*addr + sfse->Length;            //Pozycja kolejnego rekordu
	*size=sfse->Length - sfse->DataOffset; //Zwr dugo pliku
	return true;                           //Zwracamy prawidowy rekord
}