/*
 * DataFLASH_DMA.c
 *
 * Created: 2013-04-27 09:09:18
 *  Author: tmf
 */ 



#include <avr/interrupt.h>

#include <stddef.h>
#include <stdbool.h>
#include "SPI.h"
#include "Alloc_safe.h"
#include "AT45CMD.h"
#include "DataFLASH.h"



uint8_t bufor[310];
uint8_t dato;

void DF_Odczyt_bufor_lokalny()
{
	uint8_t bufor1[310];
	DataFlash_AddTransaction(AT45DBX_CMDC_RD_BUF1_AF_SM, 0, bufor1, 256, false);  //Odczytaj dane z bufora nr 1 pamici
	
	SPI_Transact *trans=(SPI_Transact*)bufor1;
	while(trans->Ready==false);   //Zaczekaj na koniec transakcji
	while(trans->Ready==false);   //Ptla tylko po to, aby byo gdzie wstawi breakpointa
}


int main(void)
{
	SPI_init();
	DataFLASH_CS_init();
	
	PMIC.CTRL|=PMIC_LOLVLEN_bm;  //Odblokuj przerwania niskiego poziomu
	sei();
	
	SPI_Transact *trans=(SPI_Transact*)&bufor;
	dato=DataFlash_AddTransaction(AT45DBX_CMDC_RD_STATUS_REG, 0, 0, bufor, 1, true);  //Odczytaj rejestr stanu pamici
	if(trans->data[dato] & 0x80)  //Przejd dalej jeli bit RDY rejestru stanu jest ustawiony (pami nie jest zajta)
	{
		
		for(uint16_t i=0; i<256; i++) trans->data[4+i]=i;  //Uzupenij bufor
		DataFlash_AddTransaction(AT45DBX_CMDC_WR_BUF1, 0, bufor, 256, true);  //Zapisz dane do bufora nr 1 pamici
		
		dato=DataFlash_AddTransaction(AT45DBX_CMDC_RD_BUF1_AF_SM, 0, bufor, 256, true);  //Odczytaj dane z bufora nr 1 pamici
		
		DF_Odczyt_bufor_lokalny();
		
		dato=DataFlash_AddTransaction(AT45DBX_CMDC_RD_BUF1_AF_SM, 0, bufor, 256, true);  //Odczytaj dane z bufora nr 1 pamici
		dato=DataFlash_AddTransaction(AT45DBX_CMDC_RD_BUF1_LF_SM, 0, bufor, 256, true);  //Odczytaj dane z bufora nr 1 pamici
		dato=DataFlash_AddTransaction(AT45DBX_CMDC_RD_BUF1_LF_SM, 0, bufor, 256, true);  //Odczytaj dane z bufora nr 1 pamici
		dato=DataFlash_AddTransaction(AT45DBX_CMDC_RD_BUF1_LF_SM, 0, bufor, 256, true);  //Odczytaj dane z bufora nr 1 pamici
		dato=DataFlash_AddTransaction(AT45DBX_CMDC_RD_BUF1_LF_SM, 0, bufor, 256, true);  //Odczytaj dane z bufora nr 1 pamici
	}
	
    while(1)
    {
        //TODO:: Please write your application code 
    }
}