/*
 * SPI.c
 *
 * Created: 2013-08-05 19:42:11
 *  Author: tmf
 */

#include "SPI.h"
#include "AT45IO.h"
#include <avr/io.h>

void SPI_init()
{
	PORTD.DIR|=PIN3_bm | PIN1_bm;            //MOSI, SCK wyjcia
	PORTD.OUTSET=PIN3_bm | PIN1_bm;          //MOSI i SCK w stanie wysokim
	PORTF.OUTSET=DataFLASH_CS;               //SS w stanie wysokim
	PORTF.DIR|=DataFLASH_CS;
	USARTD0.BAUDCTRLA=0;
	USARTD0.BAUDCTRLB=0;                     //Fclk=FPER/2 - maksymalne taktowanie SPI
	USARTD0.CTRLC=USART_CMODE_MSPI_gc;       //Tryb SPI 0
	USARTD0.CTRLB=USART_TXEN_bm | USART_RXEN_bm;
}

uint8_t SPI_RW_Byte(uint8_t byte)
{
	USARTD0.DATA=byte;
	while(!(USARTD0.STATUS & USART_TXCIF_bm));
	USARTD0.STATUS=USART_TXCIF_bm;
	return USARTD0.DATA;
}
