/*
 * TransactSPI.c
 *
 * Created: 2013-11-11 11:05:01
 *  Author: tmf
 */

#include "TransactSPI.h"
#include <avr/interrupt.h>
#include <stdbool.h>
#include <util/atomic.h>
#include <avr/io.h>
#include "Alloc_safe.h"

typedef struct
{
	SPI_Transact *elements[SPI_MAXTRANS]; //Wskaniki do transakcji
	uint8_t Beg;                          //Pierwszy element bufora
	uint8_t Count;                        //Liczba elementw w buforze
} CircBuffer;

static CircBuffer SPI_TransBuffer;         //Bufor a transakcje

inline _Bool SPI_cbIsFull()
{
	return SPI_TransBuffer.Count == SPI_MAXTRANS;
}

inline _Bool SPI_cbIsEmpty()
{
	return SPI_TransBuffer.Count == 0;
}

_Bool SPI_cbAdd(SPI_Transact *elem)
{
	ATOMIC_BLOCK(ATOMIC_RESTORESTATE)
	{
		if(SPI_cbIsFull()) return false;                   //Czy jest miejsce w kolejce?
		uint8_t end = (SPI_TransBuffer.Beg + SPI_TransBuffer.Count) % SPI_MAXTRANS;
		SPI_TransBuffer.elements[end] = elem;              //Dodaj transakcj
		++SPI_TransBuffer.Count;                           //Liczba elementw w buforze
	}
	return true;      //Wszystko ok
}

SPI_Transact *SPI_cbRead()
{
	SPI_Transact *elem;
	ATOMIC_BLOCK(ATOMIC_RESTORESTATE)
	{
		if(SPI_cbIsEmpty()) return NULL;       //Bufor pusty, nie mona zwrci elementu
		elem = SPI_TransBuffer.elements[SPI_TransBuffer.Beg];
		SPI_TransBuffer.Beg = (SPI_TransBuffer.Beg + 1) % SPI_MAXTRANS;
		--SPI_TransBuffer.Count;               //Zmniejszamy liczb elementw pozostaych
	}		                                   //w buforze
	return elem;
}

void SPI_FinishTrans(SPI_Transact *elem)
{
	elem->Ready=true;                //Transakcja obsuona
	if(elem->SelfDel) free_re(elem); //Zwolnij pami
}