/*
 * VS_Recorder.c
 *
 * Created: 2013-11-23 20:54:00
 *  Author: tmf
 */ 

#include "VS_Recorder.h"
#include "ff.h"
#include <stdlib.h>
#include "RIFFHeader.h"
#include "VS1003B.h"
#include <util/atomic.h>
#include <stdio.h>
#include <avr/pgmspace.h>
#include "KBD.h"

void RecMenu_StartStop(struct _menuitem *ptritem);

//Menu nagrywania
struct _menuitem recmenu={NULL, RecMenu_StartStop, NULL, NULL, NULL,              //Start/Stop
	&(struct _menuitem){"Time 00:00:00", NULL, NULL, NULL, NULL,                  //Czas nagrywania
		&(struct _menuitem){"Back", MenuMainLoop_Back, NULL, NULL, NULL, NULL}}};



//Funkcja wywietlajca menu nagrywania
void Menu_Recorder(const struct _menuitem_gfx *ptritem)
{
	if(VS_Status > VS_NoPlaying)
	{ //Musimy najpierw skoczy odtwarzanie muzyki
		VS_Status=VS_NoPlaying;
		ATOMIC_BLOCK(ATOMIC_FORCEON) { f_close(&sound_file); }
		while(DMA_CH3_CTRLA & DMA_CH_ENABLE_bm);         //Zaczekaj na koniec aktualnego transferu DMA
		VS1003_AddCommand(VS_WRITE_CMD, VS_MODE, (uint16_t*)&((VS_SCI_MODE){.SM_SDINEW=true, .SM_RESET=true}));  //Wycz tryb nagrywania
	}

	if(menu) Menu_Free(menu);         //Zwolnij dane
	recmenu.text="Start";
	menu=&recmenu;
	MenuMainLoopExit=false;
	sprintf_P(&recmenu.next->text[5], PSTR("%02u:%02u:%02u"), 0, 0, 0);  //Uaktualnij czas w menu nagrywania
	Menu_init();     //Zainicjuj obsuge menu
	Menu_Show();     //Poka menu
	Menu_Run();      //Gwna ptla menu
	menu=NULL;
}

static inline uint16_t Swap16(uint16_t val)     //Zamie miejscami bajty w sowie
{
	asm volatile("mov __tmp_reg__, %A0" "\n\t"
	"mov %A0, %B0"         "\n\t"
	"mov %B0, __tmp_reg__" "\n\t"
	: "=r" (val)
	: "0" (val)
	);
	return val;
}

//Funkcja realizujca nagrywanie i zapis do pliku
void RecMenu_StartStop(struct _menuitem *ptritem)
{
	recmenu.text="Stop";
	Menu_Show();          //Poka tekst "Stop"

	uint16_t fileno=0;
	char filename[15];
	do
	{
		sprintf_P(filename, PSTR("Rec-%d.wav"), fileno++);    //Utwrz nazw w formacie Rec-numer
	} while(f_open(&sound_file, filename, FA_WRITE | FA_CREATE_NEW) != FR_OK);

	UINT ile;
	f_lseek(&sound_file, sizeof(IMAADPCM_Header));                       //Miejsce na nagwek RIFF
	VS1003_Rec(VS_SampleRate[VS_Settings.samplerateindex].samplerate);   //Zainicjuj nagrywanie ADPCM

	uint32_t bytesread=0;    //Liczba odczytanych bajtw
	int16_t cnt=0, rec_time=0;
	uint16_t sr=SAMPLERATE(VS_SampleRate[VS_Settings.samplerateindex].samplerate) / 4;  //Aktualny samplerate przeliczony na bitrate (ADPCM daje kompresj 1:4)

	uint8_t OldButtons=Buttons;

	while((((Buttons ^ OldButtons) & 1) == 0) || ((Buttons & 1) == 0))   //Wcinicie SW0 przerywa nagrywanie
	{
		OldButtons=Buttons;
		uint16_t wordstoread, word;
		VS1003_AddCommand(VS_READ_CMD, VS_HDAT1, &wordstoread);

		while(wordstoread)
		{
			VS1003_AddCommand(VS_READ_CMD, VS_HDAT0, &word);
			word=Swap16(word); //Zamieniamy modsz i starsz powk - big na little-endian
			f_write(&sound_file, &word, 2, &ile);
			wordstoread--;
			bytesread+=2;      //Licznik wszystkich odczytanych bajtw
			if(cnt++ == sr)
			{
				cnt=0;
				rec_time++;
				sprintf_P(&recmenu.next->text[5], PSTR("%02u:%02u:%02u"), rec_time/3600, (rec_time/60) % 60, rec_time % 60);
				Menu_Show();  //Odwie czas
			}
		}
	}

	recmenu.text="Start";
	Menu_Show();          //Poka tekst
	VS1003_AddCommand(VS_WRITE_CMD, VS_MODE, (uint16_t*)&((VS_SCI_MODE){.SM_SDINEW=true, .SM_RESET=true}));  //Wycz tryb nagrywania

	uint8_t buf[sizeof(IMAADPCM_Header)];
	memcpy_P(buf, IMAADPCM_Header, sizeof(IMAADPCM_Header));             //Skopiuj nagwek RIFF
	RIFFHeader_t *riff=(RIFFHeader_t*)buf;   //Przed zakoczeniem musimy jeszcze uaktualni nagwek RIFF pliku
	riff->SampleRate=SAMPLERATE(VS_SampleRate[VS_Settings.samplerateindex].samplerate);  //Umie info o prbkowaniu
	riff->SubChunk3Size=bytesread;   //Liczba odczytanych bajtw
	f_lseek(&sound_file, 0);
	f_write(&sound_file, buf, sizeof(IMAADPCM_Header), &ile);   //Uaktualnij nagwek RIFF
	f_close(&sound_file);  //Koczymy nagrywanie
}
