/*
 * TransactSPI.h
 *
 * Created: 2013-11-11 11:04:13
 *  Author: tmf
 */


#ifndef TRANSACTSPI_H_
#define TRANSACTSPI_H_

#include <avr/io.h>
#include <stdint.h>

#define SPI_MAXTRANS     20         //Wielko kolejnki transakcji

//Typ definujcy struktur transakcji
typedef union SPI_Transact SPI_Transact;

//Moliwe wyniki funkcji SPI_SS_Func.
//SPI_RetOK - normalnie przetwarzaj transakcj, SPI_RetIgnore - zignoruj biec transakcj, tak jakby jej nie byo,
//SPI_RetKeep - przejd do kolejnej transakcji ale dotyczcej innego urzdzenia, do tej wr za chwil
typedef enum {SPI_RetOK, SPI_RetIgnore, SPI_RetKeep} SPI_SS_Func_ret;

//Funkcja sterujca sygnaem SS. SS_en==false ustawia SS, a SS_en=true je zeruje, opcjonalnie przyjmuje wskanik do transakcji,
//ktrej dotyczy zmiana stanu SS
typedef SPI_SS_Func_ret (*SPI_SS_Func)(_Bool SS_en, SPI_Transact *transact);

union SPI_Transact
{
	struct
	{
		volatile uint8_t  Ready        : 1;    //Transakcja gotowa?
		uint8_t  SelfDel               : 1;    //Automatycznie zwolni pami?
		uint8_t  data[4];                      //Dane transakcji
	};
	uint8_t byte;
};

SPI_Transact *SPI_cbRead();
_Bool SPI_cbAdd(SPI_Transact *elem);

_Bool SPI_cbIsFull();        //true jeli kolejka jest pena
_Bool SPI_cbIsEmpty();       //true jeli kolejka jest pusta
void SPI_FinishTrans(SPI_Transact *elem);  //Zakocz transakcj - ustaw znacznik Ready i ewentualnie zwolnij pami (jeli SelfDel ustawione)

static inline _Bool SPI_IsTransCompleted(SPI_Transact *trans)  //Czy transakcja zakoczona?
{
	return trans->Ready;
}

#endif /* TRANSACTSPI_H_ */