/*
 * PW8_IRQ4.c
 *
 * Created: 2013-10-05 20:09:03
 *  Author: tmf
 */


#include <stdbool.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>

#define GET_FAR_ADDRESS(var)                  \
({                                            \
	__uint24 tmp;                             \
	__asm__ __volatile__(                     \
	"ldi	%A0, lo8(%1)"           "\n\t"    \
	"ldi	%B0, hi8(%1)"           "\n\t"    \
	"ldi	%C0, hh8(%1)"           "\n\t"    \
	: "=d" (tmp) :	"p"  (&(var)));           \
	tmp;                                      \
})

extern __memx const uint8_t _binary____intro8kHz8PWMHL_raw_end;
extern const __uint24 _binary____intro8kHz8PWMHL_raw_size;
extern __memx const uint8_t _binary____intro8kHz8PWMHL_raw_start;

#define Snd_NoPlaying      0        //Nic nie jest odgrywane
#define Snd_Playing8Bit    1        //Odtwarzamy 8-bitowe prbki

const uint8_t __memx *srcaddr;      //Adres prbek dwikowych
__uint24 samplesize;                //Dugo odtwarzanej prbki w bajtach
volatile uint8_t isPlaying;         //Stan odtwarzacza

bool OSC_wait_for_rdy(uint8_t clk)
{
	uint8_t czas=255;
	while ((!(OSC.STATUS & clk)) && (--czas)) // Czekaj na ustabilizowanie si generatora
	_delay_ms(1);
	return czas;   //false jeli generator nie wystartowa, true jeli jest ok
}

bool RC32M_en()
{
	OSC.CTRL |= OSC_RC32MEN_bm; //Wcz generator RC 32 MHz
	if(OSC_wait_for_rdy(OSC_RC32MEN_bm)) //Zaczekaj na jego poprawny start
	{
		CPU_CCP=CCP_IOREG_gc;
		CLK_CTRL=CLK_SCLKSEL_RC32M_gc;   //Wybierz zegar 32 MHz
		return true;
	}
	return false;
}

ISR(TCC1_OVF_vect)
{
	TCF0_CCABUF=*srcaddr++;
	samplesize--;
	if(samplesize == 0)
	{
		isPlaying=Snd_NoPlaying;
		TCF0_CTRLA=TC_CLKSEL_OFF_gc;  //Koniec odtwarzania dwikw
		TCC1.CTRLA=TC_CLKSEL_OFF_gc;
	}
}

void Snd_init(const uint8_t __memx *smpaddr, __uint24 smpsize, uint16_t bitrate, _Bool HiRes)
{
	void Timer_init(uint16_t samplerate)  //Generuje zdarzenia wywoujce konwersj DAC i przeczanie buforw
	{
		PORTF_DIRSET=PIN0_bm;      //Wyjcie CCA
		TCF0.PER=0xff;
		TCF0.CTRLB=TC_WGMODE_SS_gc | TC0_CCAEN_bm;
		TCF0.CTRLA=TC_CLKSEL_DIV1_gc;

		TCC1.PER=F_CPU/samplerate-1;
		TCC1.CTRLB=TC_WGMODE_NORMAL_gc;
		TCC1.INTCTRLA=TC_OVFINTLVL_LO_gc;
		TCC1.CTRLA=TC_CLKSEL_DIV1_gc;
	}

	samplesize=smpsize;           //Dugo odtwarzanej prbki w bajtach
	srcaddr=smpaddr;              //Adres prbki

	Timer_init(bitrate);          //Zainicjuj timer z odpowiednim samplerate
	isPlaying=Snd_Playing8Bit;
}

int main(void)
{
	RC32M_en();                 //Wcz generator RC 32 MHz
	isPlaying=Snd_NoPlaying;
	PMIC_CTRL=PMIC_LOLVLEN_bm;  //Odblokuj przerwania najniszego poziomu
	sei();

	PORTD_PIN0CTRL=PORT_OPC_PULLUP_gc; //Wczamy pullup na SW0

	while(1)
	{
		if(((PORTD_IN & PIN0_bm) == 0) && (isPlaying == Snd_NoPlaying))
		Snd_init((const uint8_t __memx *)GET_FAR_ADDRESS(_binary____intro8kHz8PWMHL_raw_start), GET_FAR_ADDRESS(_binary____intro8kHz8PWMHL_raw_size), 8000, false);  //Zagraj prbk 8kHz/8 bitw
	}
}
