/*
 * ADPCM_Dialogic.c
 *
 * Created: 2013-10-14 17:02:09
 *  Author: tmf
 */

#include "ADPCM-Dialogic.h"

/* Table of index changes */
static const int8_t __flash IndexTable[16] = {
  -1, -1, -1, -1, 2, 4, 6, 8,
  -1, -1, -1, -1, 2, 4, 6, 8
};

static const uint16_t __flash StepSizeTable[49] = {
  16, 17, 19, 21, 23, 25, 28, 31, 34, 37, 41, 45,
  50, 55, 60, 66, 73, 80, 88, 97, 107, 118, 130, 143,
  157, 173, 190, 209, 230, 253, 279, 307, 337, 371, 408, 449,
  494, 544, 598, 658, 724, 796, 876, 963, 1060, 1166, 1282, 1411, 1552
};

int8_t ADPCM_index;              //Indeks do tablicy wielkoci krokw
__int24 ADPCM_predsample;        //Predyktor

//ADPCMEncoder - funkcja kodera ADPCM
//sample - 16-bitowa warto prbki (signed)
//Zwraca 4-bitowy kod ADPCM
uint8_t ADPCMEncoder(int16_t sample)
{
	uint8_t code;     //Wyliczony kod ADPCM
	int16_t tempstep; //Wielko kroku
	int16_t diff;     //Rnica pomidzy aktualn prbk a predyktorem
	int16_t step;     //Wielko kroku kwantyzacji
	int16_t diffq;    //Odtworzona szacowana rnica wartoci prbek

	step = StepSizeTable[ADPCM_index];

	diff = sample - ADPCM_predsample;  //Wylicz rnic pomidzy biec wartoci prbki, a poprzedni
	if(diff >= 0) code=0;
	else
	{
		code=8;
		diff=-diff;
	}

	tempstep=step;         //Kwantyzuj rnic pomidzy prbkami i zakoduj j w postaci 4-bitowego kodu ADPCM
	if(diff >= tempstep)
	{
		code|=4;
		diff-=tempstep;
	}
	tempstep>>=1;
	if(diff >= tempstep)
	{
		code|=2;
		diff-=tempstep;
	}
	tempstep>>=1;
	if(diff >= tempstep) code|=1;

	diffq=step >> 3;                 //Zamie kod ADPCM na szacowan rnic przy pomocy wielkoci kroku kwantyzatora
	if(code & 4) diffq+=step;
	if(code & 2) diffq+=step >> 1;
	if(code & 1) diffq+=step >> 2;

	if(code & 8) ADPCM_predsample-=diffq;  //Wylicz predyktor na podstawie poprzedniej jego wartoci i szacowanej rnicy
	else ADPCM_predsample+=diffq;

	if(ADPCM_predsample > ADPCM_MAX_POS) ADPCM_predsample=ADPCM_MAX_POS;  //Sprawd czy nie doszo do przepenienia zakresu predyktora
	else if(ADPCM_predsample < ADPCM_MAX_NEG) ADPCM_predsample=ADPCM_MAX_NEG;

	ADPCM_index += IndexTable[code];     //Znajd nowy krok kwantyzatora
	if(ADPCM_index < 0) ADPCM_index=0;   //Sprawd czy nie doszo do przekroczenia indeksu tablicy wielkoci kroku
	if(ADPCM_index > ADPCM_MAX_INDEX) ADPCM_index=ADPCM_MAX_INDEX;

	return code & 0x0F;  //Zwr kod ADPCM - 4 najmodsze bity
}

// ADPCMDecoder - funkcja dekodera ADPCM
// Wyjcie to 16-bitowa prbka w kodzie U2

int16_t ADPCMDecoder(uint8_t code)
{
	int ADPCM_step;                  //Krok kwantyzatora
	int ADPCM_diffq;                 //Przewidywana warto

	ADPCM_step = StepSizeTable[ADPCM_index];
	ADPCM_diffq=ADPCM_step >> 3;
	if(code & 4) ADPCM_diffq+=ADPCM_step;
	if(code & 2) ADPCM_diffq+=ADPCM_step >> 1;
	if(code & 1) ADPCM_diffq+=ADPCM_step >> 2;
	if(code & 8) ADPCM_predsample-=ADPCM_diffq; else ADPCM_predsample+=ADPCM_diffq;
	if(ADPCM_predsample > ADPCM_MAX_POS) ADPCM_predsample=ADPCM_MAX_POS;            //Musimy zadba o odpowiednie "zawijanie" zmiennej
	else if(ADPCM_predsample < ADPCM_MAX_NEG) ADPCM_predsample=ADPCM_MAX_NEG;
	ADPCM_index += IndexTable[code];   //Nowy krok kwantyzatora
	if(ADPCM_index < 0) ADPCM_index=0; //Zawi indeks
	if(ADPCM_index > ADPCM_MAX_INDEX) ADPCM_index=ADPCM_MAX_INDEX;
	return ADPCM_predsample;
}
