/*
 * DataFLASH.c
 *
 * Created: 2013-03-18 22:13:25
 *  Author: tmf
 */


#include <stddef.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>
#include "AT45CMD.h"
#include "AT45IO.h"
#include "SPI.h"

void SPI_init()
{
	PORTD.DIR|=PIN3_bm | PIN1_bm;            //MOSI, SCK wyjcia
	PORTD.OUTSET=PIN3_bm | PIN1_bm;          //MOSI i SCK w stanie wysokim
	PORTF.OUTSET=DataFLASH_CS;               //SS w stanie wysokim
	PORTF.DIR|=DataFLASH_CS;
	USARTD0.BAUDCTRLA=0;
	USARTD0.BAUDCTRLB=0;                     //Fclk=FPER/2 - maksymalne taktowanie SPI
	USARTD0.CTRLC=USART_CMODE_MSPI_gc;       //Tryb SPI 0
	USARTD0.CTRLB=USART_TXEN_bm | USART_RXEN_bm;
}

uint8_t SPI_RW_Byte(uint8_t byte)
{
	USARTD0.DATA=byte;
	while(!(USARTD0.STATUS & USART_TXCIF_bm));
	USARTD0.STATUS=USART_TXCIF_bm;
	return USARTD0.DATA;
}

DataFLASH_Status DF_Status;
DataFLASH_ID DF_ID;

uint8_t tbl[256];

int main(void)
{

	SPI_init();

	DataFLASH_SendCmd(AT45DBX_CMDC_RD_MNFCT_DEV_ID_SM, ADDRANDSIZE(DF_ID)); //Pobierz identyfikator pamici
	DataFLASH_SendCmd(AT45DBX_CMDC_RD_STATUS_REG, ADDRANDSIZE(DF_Status));  //Pobierz warto rejestru stanu

    DataFLASH_SendCmdAddr(AT45DBX_CMDC_WR_BUF1, 0, CS_Low);

	for(uint16_t index=0; index<256; index++)     //Wylij/odczytaj dane
	{
		SPI_RW_Byte(index);
	}
	DataFLASH_CSEnable(false);

	DataFLASH_SendCmdAddr(AT45DBX_CMDC_RD_BUF1_AF_SM, 0, CS_Low);
	for(uint16_t index=0; index<256; index++)     //Wylij/odczytaj dane
	{
		tbl[index]=SPI_RW_Byte(0);
	}
	DataFLASH_CSEnable(false);

	//DataFLASH_SendCmdAddr(AT45DBX_CMDB_ER_CHIP, CS_High);  //Skasuj ca pami
	//DataFLASH_WaitForBusy();

	DataFLASH_SendCmdAddr(AT45DBX_CMDB_PR_BUF1_TO_PAGE_ER, 4*DataFLASH_PageSize, CS_High); //Zapisz bufor 1 pod adres strony nr 4
	DataFLASH_WaitForBusy();

	DataFLASH_SendCmdAddr(AT45DBX_CMDB_XFR_PAGE_TO_BUF1, 4*DataFLASH_PageSize, CS_High); //Przepisz stron nr 4 do bufora nr 1
	DataFLASH_WaitForBusy(); //Zaczekaj na gotowo pamici
	DataFLASH_SendCmdAddr(AT45DBX_CMDC_RD_BUF1_AF_SM, 0, CS_Low);
	for(uint16_t index=0; index<256; index++)     //Wylij/odczytaj dane
	{
		tbl[index]=SPI_RW_Byte(0);
	}
	DataFLASH_CSEnable(false);

	for(uint16_t index=0; index<256; index++) tbl[index]=255; //Wyczy tablic

	DataFLASH_ReadSeq(4*DataFLASH_PageSize, tbl, sizeof(tbl));   //Odczytaj dane
	DataFLASH_ReadSeq(5*DataFLASH_PageSize, tbl, sizeof(tbl));   //Odczytaj dane

//Upienie pamici

	DataFLASH_SendCmd(AT45DBX_CMDD_DEEP_PWR_DN, NULL, 0);  //Wejd w tryb upienia

//Poniewa pami jest w trybie upienia ponisze instrukcje, a do instrukcji wybudzenia s ignorowane
	DataFLASH_SendCmdAddr(AT45DBX_CMDB_XFR_PAGE_TO_BUF1, 4*DataFLASH_PageSize, CS_High); //Przepisz stron nr 4 do bufora nr 1
	DataFLASH_SendCmdAddr(AT45DBX_CMDC_RD_BUF1_AF_SM, 0, CS_Low);
	for(uint16_t index=0; index<256; index++)     //Wylij/odczytaj dane
	{
		tbl[index]=SPI_RW_Byte(0);
	}
	DataFLASH_CSEnable(false);

	DataFLASH_SendCmd(AT45DBX_CMDD_RSM_DEEP_PWR_DN, NULL, 0);  //Wyjd z trybu upienia
	_delay_us(35);  //Odczekaj a pami bdzie gotowa na przyjcie polece
	//Pami gotowa - dalsze polecenia.

	DataFLASH_SendCmdAddr(AT45DBX_CMDB_XFR_PAGE_TO_BUF1, 4*DataFLASH_PageSize, CS_High); //Przepisz stron nr 4 do bufora nr 1
	DataFLASH_SendCmdAddr(AT45DBX_CMDC_RD_BUF1_AF_SM, 0, CS_Low);
	for(uint16_t index=0; index<256; index++)     //Wylij/odczytaj dane
	{
		tbl[index]=SPI_RW_Byte(0);
	}
	DataFLASH_CSEnable(false);

	while(1)
    {
        //TODO:: Please write your application code
    }
}