/*
 * SPI.h
 *
 * Created: 2013-04-25 20:26:18
 *  Author: tmf
 */ 


#ifndef SPI_H_
#define SPI_H_

#include <avr/io.h>
#include <stdint.h>

#define SPI_MAXTRANS     20         //Wielko kolejnki transakcji

//Typ definujcy struktur transakcji
typedef union SPI_Transact SPI_Transact;

//Moliwe wyniki funkcji SPI_SS_Func.
//SPI_RetOK - normalnie przetwarzaj transakcj, SPI_RetIgnore - zignoruj biec transakcj, tak jakby jej nie byo,
//SPI_RetKeep - przejd do kolejnej transakcji ale dotyczcej innego urzdzenia, do tej wr za chwil
typedef enum {SPI_RetOK, SPI_RetIgnore, SPI_RetKeep} SPI_SS_Func_ret;

//Funkcja sterujca sygnaem SS. SS_en==false ustawia SS, a SS_en=true je zeruje, opcjonalnie przyjmuje wskanik do transakcji,
//ktrej dotyczy zmiana stanu SS
typedef SPI_SS_Func_ret (*SPI_SS_Func)(_Bool SS_en, SPI_Transact *transact);

union SPI_Transact
{
	struct
	{
		volatile uint8_t  Ready        : 1;    //Transakcja gotowa?
		uint8_t  SelfDel               : 1;    //Automatycznie zwolni pami?
		SPI_SS_Func SS_Func;                   //Wskanik na funkcj odpowiedzialn za sterowanie sygnaem SS
		uint16_t Size;                         //Dugo bloku danych
		uint8_t  data[];                       //Dane transakcji
	};
	uint8_t byte;
};


//Inicjalizacja interfejsu SPI
void SPI_init();

SPI_Transact *SPI_cbRead();
_Bool SPI_cbAdd(SPI_Transact *elem);
void DMA_SPI_SetAddr(uint16_t addr, uint16_t size);

static inline _Bool SPI_IsTransCompleted(SPI_Transact *trans)  //Czy transakcja zakoczona?
{
	return trans->Ready;
}

#endif /* SPI_H_ */