/*
 * DataFLASH.c
 *
 * Created: 2013-04-29 11:40:59
 *  Author: tmf
 */

#include "DataFLASH.h"
#include "AT45CMD.h"
#include <math.h>

uint8_t DataFlash_AddTransaction(uint8_t cmd, uint8_t addbytes, __uint24 addr, void *bufor, uint16_t size, _Bool block)
{
	uint8_t dataoffset=1 + addbytes;

	((SPI_Transact*)bufor)->Size=size+addbytes+1;         //Liczba bajtw do przetransmitowania w ramach transakcji + bajt na polecenie
	((SPI_Transact*)bufor)->data[0]=cmd;                  //Transmitowane polecenie
	if((cmd!=AT45DBX_CMDC_RD_STATUS_REG) &&               //Dla podanych polece nie wysya si 24-bitowego adresu
	(cmd!=AT45DBX_CMDC_RD_MNFCT_DEV_ID_SM) &&
	(cmd!=AT45DBX_CMDD_DEEP_PWR_DN) &&
	(cmd!=AT45DBX_CMDD_RSM_DEEP_PWR_DN))
	{
		if(DataFLASH_Granularity==false)
		    if(cmd != 0xC7) addr=((addr / DataFLASH_PageSize) << (uint8_t)round(log(DataFLASH_PageSize) / log(2) + 0.5)) | (addr % DataFLASH_PageSize);
		((SPI_Transact*)bufor)->data[1]=(addr >> 16) & 0xff;  //Wylij 3 bajty tworzce 24-bitowy adres
		((SPI_Transact*)bufor)->data[2]=(addr >> 8) & 0xff;
		((SPI_Transact*)bufor)->data[3]=addr & 0xff;
		((SPI_Transact*)bufor)->Size+=3;                      //Uwzgldnij dugo pola adresu
		dataoffset+=3;
	}

	((SPI_Transact*)bufor)->Ready=false;
	((SPI_Transact*)bufor)->SelfDel=false;
	((SPI_Transact*)bufor)->SS_Func=DataFLASH_CSEnable; //Funkcja odpowiedzialna m.in. za zmian sygnau CS
	while(SPI_cbAdd(bufor) == false);             //Dodaj transakcj do realizacji
	if(block)
	    while(((SPI_Transact*)bufor)->Ready == false); //Jeli transakcja blokujca to czekamy na jej koniec
	return dataoffset;     //Zwr offset do danych w polu data
}

SPI_SS_Func_ret DataFLASH_CSEnable(_Bool SS_en, SPI_Transact *transact)
{
	if(SS_en) PORTF_OUTCLR=DataFLASH_CS;
	else PORTF_OUTSET=DataFLASH_CS;
	return SPI_RetOK;                  //Normalnie obsu transakcj
}