/*
 * ADCOffset.c
 *
 * Created: 2013-07-26 20:12:18
 *  Author: tmf
 */


#include <avr/io.h>
#include <stddef.h>
#include <avr\pgmspace.h>
#include "ADCOffset.h"

uint8_t ReadCalibrationByte(uint8_t index)
{
	uint8_t result;

	NVM_CMD=NVM_CMD_READ_CALIB_ROW_gc; //Odczytaj sygnatur produkcyjn
	result=pgm_read_byte(index);

	NVM_CMD=NVM_CMD_NO_OPERATION_gc;   //Przywr normalne dziaanie NVM
	return result;
}

void ADC_meas_Vcc_Config()
{
	ADCA.CTRLB=ADC_IMPMODE_bm | ADC_CURRLIMIT_NO_gc | ADC_CONMODE_bm; //Tryb signed, 12-bit
	ADCA.REFCTRL=ADC_REFSEL_INT1V_gc | ADC_BANDGAP_bm; //Odniesienie 1V
	ADCA.PRESCALER=ADC_PRESCALER_DIV16_gc;             //Probkowanie 125 ksps
	ADCA.CH0.CTRL=ADC_CH_GAIN_1X_gc | ADC_CH_INPUTMODE_INTERNAL_gc;
	ADCA.CH0.MUXCTRL=ADC_CH_MUXINT_SCALEDVCC_gc;       //Mierzymy Vcc/10

	ADCA.CALL=ReadCalibrationByte(offsetof(NVM_PROD_SIGNATURES_t, ADCACAL0));
	ADCA.CALH=ReadCalibrationByte(offsetof(NVM_PROD_SIGNATURES_t, ADCACAL1));

	ADCA.CTRLA=ADC_DMASEL_OFF_gc | ADC_ENABLE_bm;
}

uint16_t ADC_GetResults()
{
	uint32_t accum=0;
	uint16_t counter=0;
	do{
		ADCA.CH0.CTRL|=ADC_CH_START_bm;     //Rozpocznij konwersj
		while(!(ADCA.CH0.INTFLAGS & ADC_CH_CHIF_bm)); //Zaczekaj na koniec
		ADCA.CH0.INTFLAGS=ADC_CH_CHIF_bm;             //Skasuj flag koca przetwarzania
		accum+=ADCA.CH0RES;
		counter++;
	} while(counter<1024);
	return accum/1024;
}

uint16_t ADC_Meas_OffsetError_Unsigned_Mode()
{
	ADCA.CTRLB=ADC_IMPMODE_bm | ADC_CURRLIMIT_NO_gc;   //Tryb unsigned, 12-bit
	ADCA.REFCTRL=ADC_REFSEL_INT1V_gc | ADC_BANDGAP_bm; //Odniesienie 1V
	ADCA.PRESCALER=ADC_PRESCALER_DIV16_gc;             //Probkowanie 125 ksps

	ADCA.CALL=ReadCalibrationByte(offsetof(NVM_PROD_SIGNATURES_t, ADCACAL0));
	ADCA.CALH=ReadCalibrationByte(offsetof(NVM_PROD_SIGNATURES_t, ADCACAL1));

	ADCA.CTRLA=ADC_DMASEL_OFF_gc | ADC_ENABLE_bm;
	ADCA.CH0.CTRL=ADC_CH_INPUTMODE_SINGLEENDED_gc;   //Tryb z pojedynczym wejciem bez wzmocnienia
	ADCA.CH0.MUXCTRL=ADC_CH_MUXPOS_PIN1_gc;
	return ADC_GetResults();                  //Dokonaj pomiarw
}

int16_t ADC_Meas_OffsetError_Diff_Mode()
{
	ADCA.CTRLB=ADC_IMPMODE_bm | ADC_CURRLIMIT_NO_gc | ADC_CONMODE_bm; //Tryb signed, 12-bit
	ADCA.REFCTRL=ADC_REFSEL_INT1V_gc | ADC_BANDGAP_bm; //Odniesienie 1V
	ADCA.PRESCALER=ADC_PRESCALER_DIV16_gc;             //Probkowanie 125 ksps

	ADCA.CALL=ReadCalibrationByte(offsetof(NVM_PROD_SIGNATURES_t, ADCACAL0));
	ADCA.CALH=ReadCalibrationByte(offsetof(NVM_PROD_SIGNATURES_t, ADCACAL1));

	ADCA.CTRLA=ADC_DMASEL_OFF_gc | ADC_ENABLE_bm;
	ADCA.CH0.CTRL=ADC_CH_INPUTMODE_DIFF_gc;   //Tryb rnicowy bez wzmocnienia
	ADCA.CH0.MUXCTRL=ADC_CH_MUXPOS_PIN1_gc | ADC_CH_MUXNEG_PIN1_gc;
	return ADC_GetResults();                  //Dokonaj pomiarw
}

uint16_t GetTemperature()
{
	ADCA.CTRLB=ADC_IMPMODE_bm | ADC_CURRLIMIT_NO_gc;   //Tryb unsigned, 12-bit
	ADCA.REFCTRL=ADC_REFSEL_INT1V_gc | ADC_BANDGAP_bm | ADC_TEMPREF_bm; //Odniesienie 1V, wcz sensor temperatury
	ADCA.PRESCALER=ADC_PRESCALER_DIV16_gc;             //Probkowanie 125 ksps

	ADCA.CALL=ReadCalibrationByte(offsetof(NVM_PROD_SIGNATURES_t, ADCACAL0));
	ADCA.CALH=ReadCalibrationByte(offsetof(NVM_PROD_SIGNATURES_t, ADCACAL1));
	uint16_t temp85=ReadCalibrationByte(offsetof(NVM_PROD_SIGNATURES_t, TEMPSENSE0)) + (ReadCalibrationByte(offsetof(NVM_PROD_SIGNATURES_t, TEMPSENSE1)) << 8);

	ADCA.CTRLA=ADC_DMASEL_OFF_gc | ADC_ENABLE_bm;
	ADCA.CH0.CTRL=ADC_CH_INPUTMODE_INTERNAL_gc;   //Tryb rnicowy bez wzmocnienia
	ADCA.CH0.MUXCTRL=ADC_CH_MUXINT_TEMP_gc;       //Pomiar temperatury
	uint16_t temp=ADC_GetResults();               //Dokonaj pomiarw
	return (358UL*temp)/temp85 - 273;
}

