/*
 * DataFLASH.h
 *
 * Created: 2013-04-29 11:36:07
 *  Author: tmf
 */ 


#ifndef DATAFLASH_H_
#define DATAFLASH_H_

#include "SPI.h"
#include <stdbool.h>

#define DataFLASH_CS     PIN4_bm    //SygnaCS

static const _Bool DataFLASH_Granularity = false;  //false - strony nie s wielkoci potg liczby 2
static const uint16_t DataFLASH_PageSize = 1056;   //Dugo strony pamici

//Funkcja sterujca lini CS ukadu (SS_en==true ukad wybrany), transact - wskanik do transakcji, dla ktrej wywoywana jest funkcja
SPI_SS_Func_ret DataFLASH_CSEnable(_Bool SS_en, SPI_Transact *transact);

//Funkcja dodaje transakcj do kolejki
//cmd - polecenie wysyane do DataFLASH, addbytes - ewnetualne dodatkowe bajty wymagane dla polecenia
//addr - adres (dla polece go wymagajcych), jeli polecenie nie wymaga adresu to warto bez znaczenia
//bufor - wskanik do bufora - musi by on wystarczajco duy dla pomieszczenia danych i polece
//size - wielko bloku danych w bajtach
//block - true - polecenie wraca dopiero w chwili zakoczenia transakcji
uint8_t DataFlash_AddTransaction(uint8_t cmd, uint8_t addbytes, __uint24 addr, void *bufor, uint16_t size, _Bool block);

static inline void DataFLASH_CS_init()
{
	PORTF.OUTSET=DataFLASH_CS;               //SS w stanie wysokim
	PORTF.DIR|=DataFLASH_CS;
}

#endif /* DATAFLASH_H_ */