/*
 * enkoder_soft.c
 *
 * Created: 2012-04-14 17:36:05
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <stdlib.h>
#include "LCD.h"

int8_t enc_delta;

void ReadEncoder()
{
 static int8_t last;
 int8_t newpos, diff;

 newpos=0;
 if((PORTC_IN & 1)==0) newpos=3;
 if((PORTC_IN & 2)==0) newpos^=1;  // konwersja kodu Graya na binarny
 diff=last-newpos;
 if(diff & 1)
 {                              // bit 0 = krok
  last=newpos;
  enc_delta+=(diff & 2)-1;      //bit 1 - kierunek
 }
}

int8_t encode_read1()
{
 ReadEncoder();
 int8_t val=enc_delta;
 enc_delta=0;
 return val;
}

int main(void)
{
	char bufor[6];                     //Bufor na liczb
	int8_t cnt, tmpcnt;
	
	PORTCFG_MPCMASK=0b00000011;         //Zapisz now konfiguracj do pinw 0 i 1
	PORTC_PIN0CTRL=PORT_OPC_PULLUP_gc;  //Wcz podciganie do Vcc

	lcd_init();
	
    while(1)
    {
		cnt+=encode_read1();
		if(tmpcnt!=cnt)
		{
			tmpcnt=cnt;
            itoa(cnt/4, bufor, 10);           //Konwersja wartoci CNT na tekst
			lcd_cls();                        //Skasuj lcd
		    lcd_puttext(bufor);               //Wywietl warto na LCD
		}			
    }
}