/*
 * Kaskada.c
 *
 * Created: 2013-03-03 10:08:28
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <util/delay.h>

uint32_t GetCNT()
{
	EVSYS_STROBE=(1<<1);    //Wygeneruj zdarzenie w kanale 1
	return (uint32_t)TCC1_CCA<<16 | TCC0_CCA; //Zwr warto CNT
}

volatile uint32_t cnt;

int main(void)
{
	EVSYS_CH0MUX=EVSYS_CHMUX_TCC0_OVF_gc;
	EVSYS_CH1MUX=EVSYS_CHMUX_OFF_gc; //adne zdarzenie nie jest zwizane z kanaem 1
	TCC1.CTRLA=TC_CLKSEL_EVCH0_gc;
	TCC1.CTRLB=TC_WGMODE_NORMAL_gc | TC1_CCAEN_bm;
	
	TCC1.CTRLD=TC0_EVDLY_bm | TC_EVACT_CAPT_gc | TC_EVSEL_CH1_gc;       //Opnij zdarzenie o 1 takt CLKper, przechwytywanie
	
	TCC0.CTRLB=TC_WGMODE_NORMAL_gc | TC0_CCAEN_bm;
	TCC0.CTRLD=TC_EVACT_CAPT_gc | TC_EVSEL_CH1_gc;
	TCC0.CTRLA=TC_CLKSEL_DIV2_gc;
	
    while(1)
	{
		cnt=GetCNT();
		_delay_us(10);
	}
}
