/*
 * Master.c
 *
 * Created: 2013-02-15 14:46:58
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <avr/pgmspace.h>
#include "usart.h"

#define F_CARRIER 38000UL

void USART_init()
{
	USARTE0.CTRLB=USART_TXEN_bm;         //Wcz nadajnik USART
	USARTE0.CTRLC=USART_CHSIZE_8BIT_gc;  //Ramka 8 bitw, bez parzystoci, 1 bit stopu
	usart_set_baudrate(&USARTE0, 1800, F_CPU);

	PORTE_OUTSET=PIN3_bm;
	PORTE_DIRSET=PIN3_bm;  //Pin TxD musi by wyjciem w stanie wysokim
	PORTE_PIN3CTRL|=PORT_INVEN_bm;
}

void timer_init()
{
	TCE0.CTRLA=TC_CLKSEL_DIV1_gc;
	TCE0.CTRLB=TC_WGMODE_SINGLESLOPE_gc | TC0_CCDEN_bm;  //Na PIN3 bdzie wyprowadzony przebieg PWM
	TCE0.PER=F_CPU/F_CARRIER - 1;   //Czstotliwo nonej
	TCE0.CCD=TCE0.PER/2;            //Wypenienie 50%
}

int main(void)
{
	USART_init();
	timer_init();
	while(1)
	{
		USART_send_F(&USARTE0, PSTR("Pozdrowienia przeslane przez IR!\n\r"));
	}
}