/*
 * CanonRC1.c
 *
 * Created: 2013-02-12 21:13:19
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <util/delay.h>

#define F_CARRIER  32700   //Czstotliwo fali nonej
#define PULSE_WIDTH  500   //Dugo impulsu
#define PULSE_SPACE 7520   //Dugo impulsu dla natychnmiastowego wyzwolenia (us)
#define PULSE_SPC2  5520   //Dugo impulsu dla wyzwolenia po 2 s

void wave_init()
{
	TCC0.PER=F_CPU/F_CARRIER -1;       //Ustaw czstotliwo nonej
	TCC0.CCD=TCC0.PER/2;               //Wypenienie mniej wicej 50%
	TCC0.CTRLB=TC_WGMODE_SINGLESLOPE_gc;
	TCC0.CTRLA=TC_CLKSEL_DIV1_gc;    //Wcz timer
	PORTC.DIRSET=0b00001000;       //PC3 jest wyjciem
	PORTC.OUTCLR=0b00001000;       //Domylnie w stanie 0
}

void btn_init()
{
	PORTF.PIN1CTRL=PORT_OPC_PULLUP_gc;   //Wcz pullupy na PF1 i PF2
	PORTF.PIN2CTRL=PORT_OPC_PULLUP_gc;
}

void IR_send_pulse()
{
	TCC0_CTRLB|=TC0_CCDEN_bm;   //Wcz modulacj
	_delay_us(PULSE_WIDTH);
	TCC0_CTRLB&=~TC0_CCDEN_bm;  //Wcz modulacj
}

int main(void)
{
	wave_init();
	btn_init();
	while(1)
	{
		if(!(PORTF_IN & PIN1_bm))     //SW1 - natychmiastowe wyzwolenie migawki
		{
			IR_send_pulse();
			_delay_us(PULSE_SPACE);
			IR_send_pulse();
			_delay_ms(500);
		}
		if(!(PORTF_IN & PIN2_bm))     //SW2 - wyzwolenie migawki po 2 s
		{
			IR_send_pulse();
			_delay_us(PULSE_SPC2);
			IR_send_pulse();
			_delay_ms(500);
		}
	}
}