/*
 * FSMswitch.c
 *
 * Created: 2012-12-28 14:46:48
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <avr/interrupt.h>

void LED_init()
{
	PORTE.OUTSET=PIN0_bm;   //Dioda LED0 wyczona
	PORTE.DIRSET=PIN0_bm;
}

void LED_off()
{
	PORTE_OUTSET=PIN0_bm;     //Zga diod
}

void LED_on()
{
	PORTE_OUTCLR=PIN0_bm;     //Wcz diod
}

enum States {St_Wait, St_SW1, St_SW2, St_LED};  //Stany automatu
enum States currState=St_Wait;                  //Stan pocztkowy

ISR(TCC1_OVF_vect)
{
	static uint8_t Buttons;
	
	uint8_t OldButtons=Buttons;
	Buttons=PORTD_IN;

	OldButtons^=Buttons;
	if((OldButtons) && ((OldButtons & Buttons)==0))
	{
		switch(currState)
		{
			case St_Wait:  if(OldButtons & PIN1_bm) currState=St_SW1; break;
			case St_SW1 :  if(OldButtons & PIN2_bm) currState=St_SW2; else currState=St_Wait; break;
			case St_SW2 :  if(OldButtons & PIN3_bm) {currState=St_LED; LED_on();} else currState=St_Wait;break;
			case St_LED :  currState=St_Wait; break;
		};
		if(currState==St_Wait) LED_off();
	}
}

void Btn_init()
{
	PORTCFG_MPCMASK=PIN0_bm | PIN1_bm | PIN2_bm | PIN3_bm; //Klawisze SW0-SW3
	PORTD_PIN0CTRL=PORT_OPC_PULLUP_gc;  //Wczamy podciganie pod SW0-SW3

	TCC1.INTCTRLA=TC_OVFINTLVL_LO_gc;
	TCC1.PER=F_CPU/8/30;   //Okres timera - ok. 30 przerwa/sekund
	PMIC_CTRL|=PMIC_LOLVLEN_bm;

	TCC1.CTRLA=TC_CLKSEL_DIV8_gc;  //Preskaler timenra na 8
}

int main(void)
{
	LED_init();
	Btn_init();
	sei();
    while(1)
    {
        //TODO:: Please write your application code 
    }
}