/*
 * bufusart.c
 *
 * Created: 2013-01-24 18:13:44
 *  Author: tmf
 */ 

#include "bufusart.h"
#include "usart.h"
#include <avr/pgmspace.h>
#include <util/atomic.h>

CircBuffer recBuf, sendBuf;
volatile uint8_t cmdrec=false;
volatile bool TxFlag=false;

ISR(USARTC0_RXC_vect)
{
	uint8_t ch=USARTC0_DATA;
	if(ch=='\r')
	{
		ch=0;
		++cmdrec;
	}
	cb_Add(&recBuf, ch);
}

ISR(USARTC0_TXC_vect)
{
	if(!cb_IsEmpty(&sendBuf))
	{
		USARTC0_DATA=cb_Read(&sendBuf);
		TxFlag=true;
	} else TxFlag=false;
}

void USART_send_buf_F(CircBuffer *buf, const char *txt)
{
	uint8_t ch;
	while ((ch=pgm_read_byte(txt++))!=0) cb_Add(&sendBuf, ch);
	ATOMIC_BLOCK(ATOMIC_RESTORESTATE)
	{
		if(!TxFlag) USARTC0_TXC_vect();
	}
}
