/*
 * HiRes.c
 *
 * Created: 2013-03-02 09:44:05
 *  Author: tmf
 */ 


#include <avr/io.h>
#include "ClkSources.h"

void Clk_init()
{
	RC32M_en();
	SelectPLL(OSC_PLLSRC_RC32M_gc, 16);
	
	CCP=CCP_IOREG_gc;              //Odblokuj moliwo zmiany
	CLK_PSCTRL=CLK_PSADIV_1_gc | CLK_PSBCDIV_2_2_gc;  //CLKper4=PLL, CLKper2=PLL/2, CLKio=PLL/4
	CCP=CCP_IOREG_gc;              //Odblokuj moliwo zmiany
	CLK.CTRL=CLK_SCLKSEL_PLL_gc;   //Wybierz jako rdo zegara PLL
}

void HiRes_init()
{
	HIRESC_CTRLA=HIRES_HREN_TC0_gc;  //Odblokuj rozszerzenie HiRes dla TC0
	PORTC_DIR=PIN0_bm;  //Kana A jest wyjciem
	TCC0.PER=0x100;
	TCC0.CTRLB=TC_WGMODE_SS_gc | TC0_CCAEN_bm;
	TCC0.CCA=0x80;
	TCC0.CTRLA=TC_CLKSEL_DIV1_gc;
}	

int main(void)
{
	Clk_init();
	HiRes_init();
	
	while(1)
	{
		//TODO:: Please write your application code
	}
}