/*
 * OSCSel.c
 *
 * Created: 2012-03-04 12:09:16
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <util/delay.h>
#include <stdbool.h>

void RC32M_en()
{
	OSC.CTRL = OSC_RC32MEN_bm; //Wcz generator RC 32 MHz
	while (!(OSC.STATUS & OSC_RC32MRDY_bm)); // Czekaj na ustabilizowanie si generatora
}

void XTAL_en_bad()   //Ta funkcja w przypadku awarii XTAL zawiesi program
{
	OSC.CTRL = OSC_XOSCEN_bm; //Wcz zewntrzny generator kwarcowy
	while (!(OSC.STATUS & OSC_RC32MRDY_bm)); // Czekaj na ustabilizowanie si generatora
}	

bool XTAL_en()
{
	OSC.CTRL = OSC_XOSCEN_bm; //Wcz zewntrzny generator kwarcowy
	uint8_t czas=255;
	while ((!(OSC.STATUS & OSC_XOSCRDY_bm)) && (--czas)) // Czekaj na ustabilizowanie si generatora
	 _delay_ms(1);
	 
	return czas;   //false jeli generator nie wystartowa, true jeli jest ok
}

int main(void)
{
	RC32M_en();
	if (XTAL_en()==false)
	{
		//Nie udao si wystartowa zewntrznego generatora kwarcowego
		RC32M_en(); //Uyjemy generatora alternatywnego
	}		
    while(1)
    {
        //TODO:: Please write your application code 
    }
}