/*
 * RGB_pilot.c
 *
 * Created: 2013-02-24 09:44:18
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>

#include "RingBuffer.h"
#include "RC5.h"

typedef struct  
{
	uint16_t Red;
	uint16_t Green;
	uint16_t Blue;
} RGB_t;

const RGB_t PROGMEM RGB[]={{0, 0, 0}, {1023, 0, 0}, {0, 1023, 0}, {0, 0, 1023}, {1023, 1023, 0}, {0, 1023, 1023}, {1023, 0, 1023}, {1023, 1023, 1023}};

void SetRGB(uint16_t ared, uint16_t agreen, uint16_t ablue)
{
	TCF0.CCA=ared;
	TCF0.CCB=agreen;
	TCF0.CCC=ablue;
}

void RGB_timer_init()
{
	PORTF.DIRSET=PIN0_bm | PIN1_bm | PIN2_bm; //Porty RGB jako wyjcie
	TCF0.CTRLB=TC_WGMODE_SS_gc  | TC0_CCAEN_bm | TC0_CCBEN_bm | TC0_CCCEN_bm; //Tryb pracy SS
	TCF0.PER=1023;  //10-bitowa gbia kolorw
	SetRGB(512, 512, 512);
	TCF0.CTRLA=TC_CLKSEL_DIV1_gc;
}

int main(void)
{
	RGB_timer_init();  //Zainicjuj sterowanie tam RGB
	IR_init();         //Zainicjuj obsug pilota
	sei();
	
	while(1)
	{
		if(cb_IsEmpty(&IR_CMD_Buffer)==false)
		{
			CB_Element cmd=cb_Read(&IR_CMD_Buffer) & 0b00111111; //Pobierz odebrany kod i wytnij z niego polecenie
			if(cmd<(sizeof(RGB)/sizeof(RGB[0])))
			      SetRGB(pgm_read_word(&RGB[cmd].Red), pgm_read_word(&RGB[cmd].Green), pgm_read_word(&RGB[cmd].Blue));
		}
	}
}
