/*
 * MatrycaStrobe.c
 *
 * Created: 2013-03-11 19:38:48
 *  Author: tmf
 */ 


#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>
#include <string.h>
#include <avr/pgmspace.h>

#include "font5x8.h"         //Tablica czcionek 5x8

#define M_WITDTH   6         //Dugo wiersza matrycy w bajtach
#define M_HEIGHT   8         //Wysoko matrycy w wierszach
#define LED_REFRESHRATE 300  //Czstotliwo odwierzania matrycy

uint8_t Bufor[M_HEIGHT][M_WITDTH+1]={  //Miejsce na bufor i adres wiersza
	{0, 0, 0, 0, 0, 0, 0b11111110},
	{0, 0, 0, 0, 0, 0, 0b11111101},
	{0, 0, 0, 0, 0, 0, 0b11111011},
	{0, 0, 0, 0, 0, 0, 0b11110111},
	{0, 0, 0, 0, 0, 0, 0b11101111},
	{0, 0, 0, 0, 0, 0, 0b11011111},
	{0, 0, 0, 0, 0, 0, 0b10111111},
	{0, 0, 0, 0, 0, 0, 0b01111111}};
		
char tekst[]="XMEGA wita!!!";      //Tekst wywietlany na matrycy

void SPI_init()
{
	PORTC.OUTCLR=PIN1_bm;
	PORTC.DIRSET=PIN3_bm | PIN1_bm;         //Pin TxD i SCK jest wyjciem
	PORTC.PIN1CTRL=PORT_ISC_RISING_gc;      //SCK generuje zdarzenie na zboczu narastajcym
	EVSYS_CH1MUX=EVSYS_CHMUX_PORTC_PIN1_gc; //Transmitowane do kanau zdarze nr 1
	
	USARTC0.CTRLB=USART_TXEN_bm;       //Odblokuj MOSI
	USARTC0.CTRLC=USART_CMODE_MSPI_gc; //Wybierz tryb SPI, MSB najpierw,
	USARTC0.BAUDCTRLA=(F_CPU/((M_WITDTH+1)*M_HEIGHT*8UL*LED_REFRESHRATE))-1; //Oblicz wymagany transfer w zalenoci od odwieania i wielkoci matrycy
	USARTC0.BAUDCTRLB=0;
}

void DMA_init()
{
	DMA.CH0.SRCADDR0=(uint16_t)Bufor & 0xff;
	DMA.CH0.SRCADDR1=((uint16_t)Bufor >> 8) & 0xff;
	DMA.CH0.SRCADDR2=0;	
	DMA.CH0.DESTADDR0=((uint16_t)&USARTC0_DATA) & 0xff;
	DMA.CH0.DESTADDR1=((uint16_t)&USARTC0_DATA >> 8) & 0xff;
	DMA.CH0.DESTADDR2=0;
	DMA.CH0.ADDRCTRL=DMA_CH_SRCRELOAD_BLOCK_gc | DMA_CH_SRCDIR_INC_gc | DMA_CH_DESTRELOAD_BURST_gc | DMA_CH_DESTDIR_FIXED_gc;
	DMA.CH0.TRIGSRC=DMA_CH_TRIGSRC_USARTC0_DRE_gc; //Pusty bufor USART wyzwala zdarzenie
	DMA.CH0.REPCNT=0;                     //Nieskoczona liczba transferw
	DMA.CH0.TRFCNT=(M_WITDTH+1)*M_HEIGHT; //Transferujemy jako blok ca tablic z danymi
	DMA.CH0.CTRLA=DMA_CH_SINGLE_bm | DMA_CH_BURSTLEN_1BYTE_gc | DMA_CH_REPEAT_bm;
	DMA.CH0.CTRLA|=DMA_CH_ENABLE_bm;      //Odblokuj transfer
	DMA.CTRL=DMA_ENABLE_bm;               //Odblokuj DMA
}

void TimerEv_init()
{
	TCC1.PER=(M_WITDTH+1)*8-1;              //Liczba bitw transmisji
	TCC1.CTRLA=TC_CLKSEL_EVCH1_gc;          //Timer taktowany jest z EVCH1, czyli impulsami taktujcymi transmisj SPI
	EVSYS_CH0MUX=EVSYS_CHMUX_TCC1_OVF_gc;   //Zdarzenie nadmiaru bdzie transmitowane do EVCH0
	PORTC.DIRSET=PIN7_bm;                   //PC7 jest wyjciem na ktrym bdzie EV_CH0
	PORTC.OUTCLR=PIN7_bm;
	PORTCFG_CLKEVOUT=PORTCFG_EVOUT_PC7_gc;  //Udostnij wyjcie z event system na PC7
	PORTCFG_EVOUTSEL=PORTCFG_EVOUTSEL_0_gc; //Na PC7 jest kana EV_CH0
}

void ASM_ROL(uint8_t cnt, uint8_t *buf) //Funkcja rotacji bitw, buf - adres bufora, cnt - jego dugo
{
	__asm__ __volatile__
	(
	"  clc"                   "\n\t"
	"__l1:"                   "\n\t"
	"  ld __tmp_reg__, %a0"   "\n\t"
	"  rol __tmp_reg__"       "\n\t"
	"  st %a0+, __tmp_reg__"  "\n\t"
	"  dec %1"                "\n\t"
	"  brne __l1"             "\n\t"
	: "=e" (buf), "=r" (cnt)
	: "0" (buf), "1" (cnt)
	: "r0");
}

int main(void)
{
	TimerEv_init();
	SPI_init();
	DMA_init();
		
	PMIC_CTRL=PMIC_LOLVLEN_bm; //Odblokuj przerwania niskiego poziomu
	sei();

    uint16_t txtcol=strlen(tekst)*FON_WIDTH;  //Oblicz ile pikseli ma tekst na szeroko
	uint16_t currcol=0;                       //Numer ostatniej wywietlanej kolumny
	uint8_t kolor=0;
	
	while(1)
	{
		uint16_t ind=(tekst[currcol/FON_WIDTH] - ' ') * FON_WIDTH + (currcol % FON_WIDTH);
		uint8_t col=pgm_read_byte(&font5x8[ind]); //Pobierz bajt opisu czcionki
		for(uint8_t p=0; p<8; p++) 
		{
			ASM_ROL(M_WITDTH, &Bufor[p][0]);
			ASM_ROL(M_WITDTH, &Bufor[p][0]); //Przesu tekst w lewo o 1 piksel (2 bity koloru)
			if(col & 1) Bufor[p][0]=Bufor[p][0] | (kolor + 1);
			col>>=1;
		}
		currcol=(currcol+1) % txtcol;
		if(currcol==0) kolor=(kolor + 1) % 3;  //Zmie kolor
		_delay_ms(100);	
	}
}
	